/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.annotations.security.permission.Permission;
import org.jboss.seam.annotations.security.permission.Permissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionMetadata {
    private Map<Class, Boolean> usesActionMask = new HashMap<Class, Boolean>();
    private Map<Class, Map<String, Long>> classActions = new HashMap<Class, Map<String, Long>>();

    private synchronized void initClassActions(Class cls) {
        if (!this.classActions.containsKey(cls)) {
            Permission[] permissions;
            HashMap<String, Long> actions = new HashMap<String, Long>();
            boolean useMask = false;
            Permissions p = cls.getAnnotation(Permissions.class);
            if (p != null && (permissions = p.value()) != null) {
                for (Permission permission : permissions) {
                    actions.put(permission.action(), permission.mask());
                    if (permission.mask() == 0L) continue;
                    useMask = true;
                }
            }
            if (useMask) {
                HashSet<Long> masks = new HashSet<Long>();
                for (String action : actions.keySet()) {
                    Long mask = (Long)actions.get(action);
                    if (masks.contains(mask)) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " defines a duplicate mask for permission action [" + action + "]");
                    }
                    if (mask == 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a valid mask value for action [" + action + "]");
                    }
                    if ((mask & mask - 1L) != 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a mask value that is a power of 2 for action [" + action + "]");
                    }
                    masks.add(mask);
                }
            }
            this.usesActionMask.put(cls, useMask);
            this.classActions.put(cls, actions);
        }
    }

    public ActionSet createActionSet(Class targetClass, String members) {
        if (!this.classActions.containsKey(targetClass)) {
            this.initClassActions(targetClass);
        }
        return new ActionSet(targetClass, members);
    }

    public List<String> listAllowableActions(Class targetClass) {
        if (!this.classActions.containsKey(targetClass)) {
            this.initClassActions(targetClass);
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (String action : this.classActions.get(targetClass).keySet()) {
            actions.add(action);
        }
        return actions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ActionSet {
        private Set<String> members = new HashSet<String>();
        private Class targetClass;

        public ActionSet(Class targetClass, String members) {
            this.targetClass = targetClass;
            this.addMembers(members);
        }

        public void addMembers(String members) {
            if (members == null) {
                return;
            }
            if (((Boolean)PermissionMetadata.this.usesActionMask.get(this.targetClass)).booleanValue()) {
                long vals = Long.valueOf(members);
                Map actions = (Map)PermissionMetadata.this.classActions.get(this.targetClass);
                for (String action : actions.keySet()) {
                    long mask = (Long)actions.get(action);
                    if ((vals & mask) == 0L) continue;
                    this.members.add(action);
                }
            } else {
                String[] actions;
                for (String action : actions = members.split(",")) {
                    this.members.add(action);
                }
            }
        }

        public boolean contains(String action) {
            return this.members.contains(action);
        }

        public ActionSet add(String action) {
            this.members.add(action);
            return this;
        }

        public ActionSet remove(String action) {
            this.members.remove(action);
            return this;
        }

        public Set<String> members() {
            return this.members;
        }

        public boolean isEmpty() {
            return this.members.isEmpty();
        }

        public String toString() {
            if (((Boolean)PermissionMetadata.this.usesActionMask.get(this.targetClass)).booleanValue()) {
                Map actions = (Map)PermissionMetadata.this.classActions.get(this.targetClass);
                long mask = 0L;
                for (String member : this.members) {
                    mask |= ((Long)actions.get(member)).longValue();
                }
                return "" + mask;
            }
            StringBuilder sb = new StringBuilder();
            for (String member : this.members) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(member);
            }
            return sb.toString();
        }
    }
}

