/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtil {
    private static Log log = LogFactory.getLog(ObjectUtil.class);

    public static Object lookupAttributeProperty(Object value, String property) {
        if (value instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)value;
            if (compositeData.containsKey(property)) {
                value = compositeData.get(property);
            } else {
                log.debug((Object)("Unable to read attribute property [" + property + "] from object data value"));
            }
        } else {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(property)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Unable to read property from measurement attribute [" + property + "] not found on [" + value + "]"));
            }
        }
        return value;
    }

    private static Set<String> getAttributeNames(Set<MeasurementScheduleRequest> requests) {
        HashSet<String> names = new HashSet<String>();
        for (MeasurementScheduleRequest request : requests) {
            names.add(ObjectUtil.getAttributeName(request.getName()));
        }
        return names;
    }

    private static String getAttributeName(String property) {
        if (property.startsWith("{")) {
            return property.substring(1, property.indexOf(46));
        }
        return property;
    }

    private static String getAttributeProperty(String property) {
        if (property.startsWith("{")) {
            return property.substring(property.indexOf(46) + 1, property.length() - 1);
        }
        return null;
    }

    public static Double lookupDeepNumericAttributeProperty(Object value, String propertyPath) {
        Object val = ObjectUtil.lookupDeepAttributeProperty(value, propertyPath);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Double.NaN;
    }

    public static Object lookupDeepAttributeProperty(Object value, String propertyPath) {
        String[] ps = propertyPath.split("\\.", 2);
        String searchProperty = ps[0];
        if (value instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)value;
            if (compositeData.containsKey(searchProperty)) {
                value = compositeData.get(searchProperty);
            } else {
                log.debug((Object)("Unable to read attribute property [" + propertyPath + "] from composite data value"));
            }
        } else {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(searchProperty)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Unable to read property from measurement attribute [" + searchProperty + "] not found on [" + (value != null ? value.getClass().getSimpleName() : "null") + "]"));
            }
        }
        if (ps.length > 1) {
            value = ObjectUtil.lookupDeepAttributeProperty(value, ps[1]);
        }
        return value;
    }
}

