/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.util.Classes;

public class ServiceValueFactoryParameterMetaData {
    private final String textValue;
    private final String valueTypeName;
    private String parameterTypeName;

    public ServiceValueFactoryParameterMetaData(String textValue) {
        this(textValue, null, null);
    }

    public ServiceValueFactoryParameterMetaData(String textValue, String parameterTypeName) {
        this(textValue, parameterTypeName, null);
    }

    public ServiceValueFactoryParameterMetaData(String textValue, String parameterTypeName, String valueTypeName) {
        this.textValue = textValue;
        this.valueTypeName = valueTypeName;
        this.parameterTypeName = parameterTypeName;
    }

    public String getParameterTypeName() {
        return this.parameterTypeName;
    }

    public void setParameterTypeName(String parameterTypeName) {
        this.parameterTypeName = parameterTypeName;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public String getValueTypeName() {
        return this.valueTypeName;
    }

    public Object getValue(ServiceValueContext valueContext) throws DeploymentException {
        if (this.parameterTypeName == null) {
            throw new IllegalStateException("Must set parameterTypeName");
        }
        String desiredType = this.valueTypeName == null ? this.parameterTypeName : this.valueTypeName;
        return ServiceValueFactoryParameterMetaData.getValue(valueContext.getClassloader(), this.textValue, desiredType, valueContext.getAttributeInfo().getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceValueFactoryParameterMetaData) {
            ServiceValueFactoryParameterMetaData other = (ServiceValueFactoryParameterMetaData)obj;
            return this.safeEquals(this.textValue, other.textValue) && this.safeEquals(this.parameterTypeName, other.parameterTypeName) && this.safeEquals(this.valueTypeName, other.valueTypeName);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result += 29 * (this.textValue == null ? 0 : this.textValue.hashCode());
        result += 29 * (this.parameterTypeName == null ? 0 : this.parameterTypeName.hashCode());
        return result += 29 * (this.valueTypeName == null ? 0 : this.valueTypeName.hashCode());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{textValue=" + this.textValue + ",parameterTypeName=" + this.parameterTypeName + ",valueTypeName=" + this.valueTypeName;
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(ClassLoader serviceValueContextClassloader, String textValue, String typeName, String targetAttributeName) throws DeploymentException {
        if (textValue == null) {
            return null;
        }
        Class<?> typeClass = Classes.getPrimitiveTypeForName((String)typeName);
        if (typeClass == null) {
            try {
                typeClass = serviceValueContextClassloader.loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Class not found for attribute: " + targetAttributeName, (Throwable)e);
            }
        }
        if (String.class == typeClass) {
            return textValue;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
        if (editor == null) {
            try {
                Class[] sig = new Class[]{String.class};
                Constructor<?> ctor = typeClass.getConstructor(sig);
                Object[] args = new Object[]{textValue};
                return ctor.newInstance(args);
            }
            catch (Exception e) {
                throw new DeploymentException("No property editor for attribute: " + targetAttributeName + "; type=" + typeClass.getName());
            }
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(serviceValueContextClassloader);
        try {
            editor.setAsText(textValue);
            Object object = editor.getValue();
            Object var10_13 = null;
            Thread.currentThread().setContextClassLoader(tcl);
            return object;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            Thread.currentThread().setContextClassLoader(tcl);
            throw throwable;
        }
    }
}

