/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.nio.AbstractConfigurable;
import org.jboss.xnio.nio.NioTcpConnector;
import org.jboss.xnio.nio.NioTcpConnectorConfig;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpConnectorFactory
extends AbstractConfigurable
implements ConfigurableFactory<CloseableTcpConnector> {
    private static final Set<ChannelOption<?>> options;
    private final NioXnio xnio;
    private final Executor executor;
    private final Object lock = new Object();
    private boolean created;

    public NioTcpConnectorFactory(NioXnio xnio, Executor executor) {
        super(options);
        this.xnio = xnio;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableTcpConnector create() throws IOException, IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.created) {
                throw new IllegalStateException("Already created");
            }
            NioTcpConnectorConfig config = new NioTcpConnectorConfig();
            config.setXnio(this.xnio);
            config.setExecutor(this.executor);
            config.setReuseAddresses((Boolean)this.getOption(CommonOptions.REUSE_ADDRESSES));
            config.setSendBuffer((Integer)this.getOption(CommonOptions.SEND_BUFFER));
            config.setReceiveBuffer((Integer)this.getOption(CommonOptions.RECEIVE_BUFFER));
            config.setKeepAlive((Boolean)this.getOption(CommonOptions.KEEP_ALIVE));
            config.setOobInline((Boolean)this.getOption(CommonOptions.TCP_OOB_INLINE));
            config.setNoDelay((Boolean)this.getOption(CommonOptions.TCP_NODELAY));
            Boolean manage = (Boolean)this.getOption(CommonOptions.MANAGE_CONNECTIONS);
            config.setManageConnections(manage != null ? manage : false);
            NioTcpConnector nioTcpConnector = NioTcpConnector.create(config);
            this.created = true;
            return nioTcpConnector;
        }
    }

    static {
        HashSet<ChannelOption> optionSet = new HashSet<ChannelOption>();
        optionSet.add(CommonOptions.REUSE_ADDRESSES);
        optionSet.add(CommonOptions.SEND_BUFFER);
        optionSet.add(CommonOptions.RECEIVE_BUFFER);
        optionSet.add(CommonOptions.KEEP_ALIVE);
        optionSet.add(CommonOptions.TCP_OOB_INLINE);
        optionSet.add(CommonOptions.TCP_NODELAY);
        optionSet.add(CommonOptions.MANAGE_CONNECTIONS);
        options = Collections.unmodifiableSet(optionSet);
    }
}

