/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.helpers;

import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SeparatorTreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.SimpleResourceTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;

public class TreeNodeFactory {
    public static final int NAME = 0;
    public static final int DESCRIPTION = 1;
    public static final int ICON_URL = 2;
    public static final int DEFAULT_URL = 3;
    public static final int MENU_ENTRIES = 4;
    public static final int SUB_NODES = 5;
    public static final int SUB_RESOURCES = 6;
    public static final int MANAGEABLE_RESOURCES = 7;

    public static TreeNode createTreeNode(Object[] content) throws Exception {
        if (content.length != 7 && content.length != 8) {
            throw new Exception("Bad number of parameters");
        }
        String name = (String)content[0];
        String description = (String)content[1];
        String iconUrl = (String)content[2];
        String defaultUrl = (String)content[3];
        HttpLinkTreeAction action = new HttpLinkTreeAction(defaultUrl);
        TreeNodeMenuEntry[] menuEntries = TreeNodeFactory.createTreeMenus((Object[])content[4]);
        TreeNode[] subNodes = null;
        Object[] genericSubNodes = (Object[])content[5];
        if (genericSubNodes != null && genericSubNodes.length > 0) {
            subNodes = new TreeNode[genericSubNodes.length];
            for (int i = 0; i < genericSubNodes.length; ++i) {
                subNodes[i] = TreeNodeFactory.createTreeNode((Object[])genericSubNodes[i]);
            }
        } else {
            subNodes = new TreeNode[]{};
        }
        ResourceTreeNode[] subResNodes = null;
        Object[] genericSubResNodes = (Object[])content[6];
        if (genericSubResNodes != null && genericSubResNodes.length > 0) {
            subResNodes = new ResourceTreeNode[genericSubResNodes.length];
            for (int i = 0; i < genericSubResNodes.length; ++i) {
                subResNodes[i] = (ResourceTreeNode)TreeNodeFactory.createTreeNode((Object[])genericSubResNodes[i]);
            }
        } else {
            subResNodes = new ResourceTreeNode[]{};
        }
        if (content.length - 1 == 7) {
            ManageableResource res = TreeNodeFactory.createManageableResource(content[7]);
            return new SimpleResourceTreeNode(name, description, iconUrl, action, menuEntries, subNodes, subResNodes, res);
        }
        return new SimpleTreeNode(name, description, iconUrl, action, menuEntries, subNodes, subResNodes);
    }

    public static ManageableResource createManageableResource(Object content) throws Exception {
        Object[] realContent = (Object[])content;
        return new MBeanResource(new ObjectName((String)realContent[0]), (String)realContent[1]);
    }

    protected static TreeNodeMenuEntry[] createTreeMenus(Object[] content) throws Exception {
        TreeNodeMenuEntry[] menuEntries = null;
        if (content != null && content.length > 0) {
            menuEntries = new TreeNodeMenuEntry[content.length];
            int i = 0;
            while (i < content.length) {
                if (content[i] == null) {
                    menuEntries[i] = new SeparatorTreeNodeMenuEntry();
                    ++i;
                    continue;
                }
                String text = (String)content[i];
                HttpLinkTreeAction action = new HttpLinkTreeAction((String)content[i + 1]);
                menuEntries[i] = new SimpleTreeNodeMenuEntryImpl(text, action);
                i += 2;
            }
        } else {
            menuEntries = new TreeNodeMenuEntry[]{};
        }
        return menuEntries;
    }
}

