/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.reflect.Method;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aspects.tx.TxInterceptor;
import org.jboss.aspects.tx.TxInterceptorFactory;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.ejb3.tx.Ejb3TxPolicy;
import org.jboss.ejb3.tx.NullInterceptor;
import org.jboss.ejb3.tx.TxInterceptor;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class CMTTxInterceptorFactory
extends TxInterceptorFactory {
    private static final Logger log = Logger.getLogger(CMTTxInterceptorFactory.class);

    protected TransactionAttributeType getTxType(Advisor advisor, Joinpoint jp) {
        Method method = ((MethodJoinpoint)jp).getMethod();
        return TxUtil.getTxType(advisor, method);
    }

    protected int resolveTransactionTimeout(Advisor advisor, Method method) {
        TransactionTimeout annotation = (TransactionTimeout)advisor.resolveAnnotation(method, TransactionTimeout.class);
        if (annotation == null) {
            annotation = (TransactionTimeout)advisor.resolveAnnotation(TransactionTimeout.class);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    protected void initializePolicy() {
        this.policy = new Ejb3TxPolicy();
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type == TransactionManagementType.BEAN) {
            return new NullInterceptor();
        }
        TransactionManager tm = TxUtil.getTransactionManager();
        Method method = ((MethodJoinpoint)jp).getMethod();
        int timeout = this.resolveTransactionTimeout(advisor, method);
        if (this.policy == null) {
            // empty if block
        }
        super.initialize();
        TransactionAttributeType txType = this.getTxType(advisor, jp);
        if (txType.equals((Object)TransactionAttributeType.NEVER)) {
            return new TxInterceptor.Never(tm, this.policy);
        }
        if (txType.equals((Object)TransactionAttributeType.REQUIRED)) {
            return new TxInterceptor.Required(tm, this.policy, timeout);
        }
        if (txType.equals((Object)TransactionAttributeType.REQUIRES_NEW)) {
            return new TxInterceptor.RequiresNew(tm, this.policy, timeout);
        }
        if (txType.equals((Object)TransactionAttributeType.NOT_SUPPORTED)) {
            return new TxInterceptor.NotSupported(tm, this.policy, timeout);
        }
        if (txType.equals((Object)TransactionAttributeType.MANDATORY)) {
            return new TxInterceptor.Mandatory(tm, this.policy, timeout);
        }
        if (txType.equals((Object)TransactionAttributeType.SUPPORTS)) {
            return new TxInterceptor.Supports(tm, this.policy, timeout);
        }
        Object interceptor = super.createPerJoinpoint(advisor, jp);
        return interceptor;
    }
}

