/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.validator;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;
import org.rhq.core.domain.configuration.definition.constraint.FloatRangeConstraint;
import org.rhq.core.domain.configuration.definition.constraint.IntegerRangeConstraint;
import org.rhq.core.domain.configuration.definition.constraint.RegexConstraint;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.validator.RegexValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySimpleValueValidator
implements Validator,
StateHolder {
    private static final String INPUT_ERROR_STYLE_CLASS = "inputerror";
    private PropertyDefinitionSimple propertyDefinition;
    private boolean transientValue;

    public PropertySimpleValueValidator() {
    }

    public PropertySimpleValueValidator(@Nullable PropertyDefinitionSimple propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
    }

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        String stringValue = (String)value;
        String refresh = FacesContextUtility.getOptionalRequestParameter("refresh");
        if (refresh != null && refresh.equals("rhq_propSet")) {
            return;
        }
        if (!this.propertyDefinition.isRequired() && value == null) {
            return;
        }
        if (!FacesComponentUtility.isOverride(component)) {
            return;
        }
        List<Validator> subValidators = this.createSubValidators();
        for (Validator subValidator : subValidators) {
            try {
                subValidator.validate(facesContext, component, (Object)stringValue);
            }
            catch (ValidatorException e) {
                component.getAttributes().put("styleClass", INPUT_ERROR_STYLE_CLASS);
                if (" ".equals(stringValue)) {
                    ((UIInput)component).setSubmittedValue((Object)"");
                }
                throw e;
            }
        }
    }

    private List<Validator> createSubValidators() {
        ArrayList<Validator> subValidators = new ArrayList<Validator>();
        subValidators.add((Validator)new LengthValidator(2000));
        if (this.propertyDefinition != null) {
            switch (this.propertyDefinition.getType()) {
                case INTEGER: {
                    subValidators.add((Validator)new LongRangeValidator(Integer.MAX_VALUE, Integer.MIN_VALUE));
                    break;
                }
                case LONG: {
                    subValidators.add((Validator)new LongRangeValidator(Long.MAX_VALUE, Long.MIN_VALUE));
                    break;
                }
                case FLOAT: {
                    subValidators.add((Validator)new DoubleRangeValidator(3.4028234663852886E38, (double)1.4E-45f));
                    break;
                }
                case DOUBLE: {
                    subValidators.add((Validator)new DoubleRangeValidator(Double.MAX_VALUE, Double.MIN_VALUE));
                }
            }
            for (Constraint constraint : this.propertyDefinition.getConstraints()) {
                subValidators.add(PropertySimpleValueValidator.createValidator(constraint));
            }
        }
        return subValidators;
    }

    @NotNull
    public static Validator createValidator(Constraint constraint) {
        RegexValidator validator;
        if (constraint instanceof IntegerRangeConstraint) {
            Long maxValue;
            IntegerRangeConstraint integerRangeConstraint = (IntegerRangeConstraint)constraint;
            LongRangeValidator longRangeValidator = new LongRangeValidator();
            Long minValue = integerRangeConstraint.getMinimum();
            if (minValue != null) {
                longRangeValidator.setMinimum(minValue.longValue());
            }
            if ((maxValue = integerRangeConstraint.getMaximum()) != null) {
                longRangeValidator.setMaximum(maxValue.longValue());
            }
            validator = longRangeValidator;
        } else if (constraint instanceof FloatRangeConstraint) {
            Double maxValue;
            FloatRangeConstraint floatRangeConstraint = (FloatRangeConstraint)constraint;
            DoubleRangeValidator doubleRangeValidator = new DoubleRangeValidator();
            Double minValue = floatRangeConstraint.getMinimum();
            if (minValue != null) {
                doubleRangeValidator.setMinimum(minValue.doubleValue());
            }
            if ((maxValue = floatRangeConstraint.getMaximum()) != null) {
                doubleRangeValidator.setMaximum(maxValue.doubleValue());
            }
            validator = doubleRangeValidator;
        } else if (constraint instanceof RegexConstraint) {
            RegexConstraint regexConstraint = (RegexConstraint)constraint;
            validator = new RegexValidator(regexConstraint.getDetails());
        } else {
            throw new IllegalArgumentException("Unknown constraint type: " + constraint.getClass().getName());
        }
        return validator;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.propertyDefinition = (PropertyDefinitionSimple)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.propertyDefinition};
        return values;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

