/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation.bridges;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.cache.invalidation.BatchInvalidation;
import org.jboss.cache.invalidation.BridgeInvalidationSubscription;
import org.jboss.cache.invalidation.InvalidationBridgeListener;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.cache.invalidation.bridges.JMSCacheInvalidationBridgeMBean;
import org.jboss.cache.invalidation.bridges.JMSCacheInvalidationMessage;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class JMSCacheInvalidationBridge
extends ServiceMBeanSupport
implements JMSCacheInvalidationBridgeMBean,
InvalidationBridgeListener,
MessageListener {
    public static final String JMS_CACHE_INVALIDATION_BRIDGE = "JMS_CACHE_INVALIDATION_BRIDGE";
    protected InvalidationManagerMBean invalMgr = null;
    protected BridgeInvalidationSubscription invalidationSubscription = null;
    protected String invalidationManagerName = "jboss.cache:service=InvalidationManager";
    protected boolean publishingAuthorized = false;
    protected String connectionFactoryName = "java:/ConnectionFactory";
    protected String topicName = "topic/JMSCacheInvalidationBridge";
    protected boolean transacted = true;
    protected int acknowledgeMode = 1;
    protected int propagationMode = 1;
    protected VMID serviceId = new VMID();
    protected TopicConnection conn = null;
    protected TopicSession session = null;
    protected Topic topic = null;
    protected TopicSubscriber subscriber = null;
    protected TopicPublisher pub = null;
    protected String providerUrl = null;

    public String getInvalidationManager() {
        return this.invalidationManagerName;
    }

    public void setInvalidationManager(String objectName) {
        this.invalidationManagerName = objectName;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String factoryName) {
        this.connectionFactoryName = factoryName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean isTransacted) {
        this.transacted = isTransacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int ackMode) {
        if (ackMode > 3 || ackMode < 1) {
            throw new RuntimeException("Value AcknowledgeMode must be between 1 and 3");
        }
        switch (ackMode) {
            case 1: {
                this.acknowledgeMode = 1;
                break;
            }
            case 2: {
                this.acknowledgeMode = 2;
                break;
            }
            case 3: {
                this.acknowledgeMode = 3;
            }
        }
    }

    public int getPropagationMode() {
        return this.propagationMode;
    }

    public void setPropagationMode(int propMode) {
        if (propMode > 3 || propMode < 1) {
            throw new RuntimeException("Value PropagationMode must be between 1 and 3");
        }
        this.propagationMode = propMode;
    }

    public void onMessage(Message msg) {
        if (this.propagationMode == 1 || this.propagationMode == 2) {
            try {
                ObjectMessage objmsg = (ObjectMessage)msg;
                if (!objmsg.getJMSType().equals(JMS_CACHE_INVALIDATION_BRIDGE)) {
                    return;
                }
                JMSCacheInvalidationMessage content = (JMSCacheInvalidationMessage)objmsg.getObject();
                if (!content.emitter.equals(this.serviceId)) {
                    if (content.invalidateAllGroupName != null) {
                        this.invalidationSubscription.invalidateAll(content.invalidateAllGroupName);
                    } else {
                        this.invalidationSubscription.batchInvalidate(content.getInvalidations());
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)ex.getMessage());
            }
        }
    }

    public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous) {
        if ((this.propagationMode == 1 || this.propagationMode == 3) && this.publishingAuthorized) {
            JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidations);
            this.sendJMSInvalidationEvent(msg);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous) {
        if ((this.propagationMode == 1 || this.propagationMode == 3) && this.publishingAuthorized) {
            JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidationGroupName, keys);
            this.sendJMSInvalidationEvent(msg);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable key, boolean asynchronous) {
        if ((this.propagationMode == 1 || this.propagationMode == 3) && this.publishingAuthorized) {
            JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, invalidationGroupName, new Serializable[]{key});
            this.sendJMSInvalidationEvent(msg);
        }
    }

    public void invalidateAll(String groupName, boolean asynchronous) {
        if ((this.propagationMode == 1 || this.propagationMode == 3) && this.publishingAuthorized) {
            JMSCacheInvalidationMessage msg = new JMSCacheInvalidationMessage(this.serviceId, groupName);
            this.sendJMSInvalidationEvent(msg);
        }
    }

    public void newGroupCreated(String groupInvalidationName) {
    }

    public void groupIsDropped(String groupInvalidationName) {
    }

    protected void startService() throws Exception {
        this.log.info((Object)"Starting JMS cache invalidation bridge");
        this.invalMgr = (InvalidationManagerMBean)Registry.lookup((Object)this.invalidationManagerName);
        this.invalidationSubscription = this.invalMgr.registerBridgeListener(this);
        InitialContext iniCtx = this.getInitialContext();
        Object tmp = iniCtx.lookup(this.connectionFactoryName);
        TopicConnectionFactory tcf = (TopicConnectionFactory)tmp;
        this.conn = tcf.createTopicConnection();
        this.topic = (Topic)iniCtx.lookup(this.topicName);
        this.session = this.conn.createTopicSession(this.transacted, this.acknowledgeMode);
        this.conn.start();
        if (this.propagationMode == 1 || this.propagationMode == 2) {
            this.subscriber = this.session.createSubscriber(this.topic);
            this.subscriber.setMessageListener((MessageListener)this);
        }
        if (this.propagationMode == 1 || this.propagationMode == 3) {
            this.pub = this.session.createPublisher(this.topic);
            this.publishingAuthorized = true;
        }
    }

    protected void stopService() {
        this.log.info((Object)"Stoping JMS cache invalidation bridge");
        try {
            if (this.propagationMode == 1 || this.propagationMode == 2) {
                this.subscriber.close();
            }
            if (this.propagationMode == 1 || this.propagationMode == 3) {
                this.publishingAuthorized = false;
                this.pub.close();
            }
            this.conn.stop();
            this.session.close();
            this.conn.close();
        }
        catch (Exception ex) {
            this.log.warn((Object)"Failed to stop JMS resources associated with the JMS bridge: ", (Throwable)ex);
        }
    }

    protected synchronized TopicSession getSession() {
        return this.session;
    }

    protected synchronized TopicPublisher getPublisher() {
        return this.pub;
    }

    protected void sendJMSInvalidationEvent(JMSCacheInvalidationMessage invalidationMsg) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("sending JMS message for cache invalidation" + invalidationMsg));
            }
            try {
                ObjectMessage msg = this.getSession().createObjectMessage();
                msg.setJMSType(JMS_CACHE_INVALIDATION_BRIDGE);
                msg.setObject((Serializable)invalidationMsg);
                this.getPublisher().publish((Message)msg);
            }
            catch (JMSException ex) {
                this.log.debug((Object)"failed to publish seppuku event: ", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"failed to do cluster seppuku event: ", (Throwable)ex);
        }
    }

    protected InitialContext getInitialContext() throws NamingException {
        if (this.providerUrl == null) {
            return new InitialContext();
        }
        this.log.debug((Object)("Using Context.PROVIDER_URL: " + this.providerUrl));
        Properties props = new Properties(System.getProperties());
        props.put("java.naming.provider.url", this.providerUrl);
        return new InitialContext(props);
    }
}

