/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import org.apache.juddi.IRegistry;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.proxy.RegistryProxy;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl;
import org.apache.ws.scout.registry.BusinessQueryManagerImpl;
import org.apache.ws.scout.registry.CapabilityProfileImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;

public class RegistryServiceImpl
implements RegistryService {
    private final RegistryProxy registry;
    private final BusinessQueryManagerImpl queryManager;
    private final BusinessLifeCycleManagerImpl lifeCycleManager;
    private final ClassificationSchemeImpl postalScheme;
    private final int maxRows;
    private ConnectionImpl connection;

    public RegistryServiceImpl(RegistryProxy registry, String postalScheme, int maxRows) {
        this.registry = registry;
        this.maxRows = maxRows;
        this.queryManager = new BusinessQueryManagerImpl(this);
        this.lifeCycleManager = new BusinessLifeCycleManagerImpl(this);
        if (postalScheme == null) {
            this.postalScheme = null;
        } else {
            this.postalScheme = new ClassificationSchemeImpl(this.lifeCycleManager);
            this.postalScheme.setKey(new KeyImpl(postalScheme));
        }
    }

    IRegistry getRegistry() {
        return this.registry;
    }

    BusinessLifeCycleManagerImpl getLifeCycleManagerImpl() {
        return this.lifeCycleManager;
    }

    int getMaxRows() {
        return this.maxRows;
    }

    public CapabilityProfile getCapabilityProfile() {
        return new CapabilityProfileImpl();
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        return this.queryManager;
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        return this.lifeCycleManager;
    }

    public BulkResponse getBulkResponse(String s) throws JAXRException, InvalidRequestException {
        if (s == "" || s == null) {
            throw new InvalidRequestException();
        }
        return null;
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        throw new UnsupportedCapabilityException();
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        return this.postalScheme;
    }

    public String makeRegistrySpecificRequest(String s) throws JAXRException {
        String inquiry = "INQUIRY";
        String publish = "PUBLISH";
        String type = "";
        String snippet = s.substring(0, 20);
        type = snippet.indexOf("save") > -1 ? publish : inquiry;
        try {
            return this.registry.execute(s, type);
        }
        catch (RegistryException e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionImpl connection) {
        this.connection = connection;
    }
}

