/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class ListDomainsCommand
extends MBeanServerCommand {
    private boolean displayCount;

    public ListDomainsCommand() {
        super("listDomains", "Query the server for a list of available domains");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options]");
        out.println("options:");
        out.println("    -c, --count    Display the domain count");
        out.println("    --             Stop processing options");
        out.flush();
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        String sopts = "-:c";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("count", 0, null, 99)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        default: 
                    }
                    throw new CommandException("Unused argument: " + arg);
                }
                case 99: {
                    this.displayCount = true;
                }
            }
        }
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        String[] domains = this.getMBeanServer().getDomains();
        PrintWriter out = this.context.getWriter();
        if (this.displayCount) {
            out.println(domains.length);
        } else {
            for (int i = 0; i < domains.length; ++i) {
                out.println(domains[i]);
            }
        }
        out.flush();
    }
}

