/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jboss.aop.DispatcherConnectException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainer;

public class BlockContainerShutdownInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -1683253088746668495L;

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object container = EJBContainer.getEJBContainer(invocation.getAdvisor());
        Lock lock = ((EJBContainer)container).getInvocationLock();
        if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
            throw new DispatcherConnectException("EJB container is not completely started, or is stopped.");
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

