/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static ReplicationGranularity getReplicationGranularity(LocalDistributableSessionManager localManager) {
        ReplicationConfig config = localManager.getReplicationConfig();
        return config.getReplicationGranularity();
    }

    public static String getCacheConfigName(LocalDistributableSessionManager localManager) {
        ReplicationConfig config = localManager.getReplicationConfig();
        return config.getCacheName();
    }

    public static PojoCache findPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = Util.getManagerForPojoCache(cacheConfigName);
        try {
            return pcm.getPojoCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    public static Cache<Object, Object> findPlainCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager pcm = Util.getManagerForCache(cacheConfigName);
        try {
            return pcm.getCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    private static PojoCacheManager getManagerForPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = null;
        try {
            pcm = PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access PojoCacheManager for JBossWeb clustering", t);
        }
        if (!pcm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("PojoCacheManager does not recognize config " + cacheConfigName);
        }
        return pcm;
    }

    private static CacheManager getManagerForCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager cm = null;
        try {
            cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access CacheManager for JBossWeb clustering", t);
        }
        if (!cm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("CacheManager does not recognize config " + cacheConfigName);
        }
        return cm;
    }

    private Util() {
    }
}

