/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.FC;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FCTest
extends TestCase {
    IpAddress a1;
    Vector members;
    View v;
    Simulator s;
    final int SIZE = 1000;
    final int NUM_MSGS = 100000;

    public FCTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        FC fc = new FC();
        Properties props = new Properties();
        props.setProperty("max_credits", "10000");
        props.setProperty("min_credits", "1000");
        props.setProperty("max_block_time", "1000");
        fc.setProperties(props);
        Protocol[] stack = new Protocol[]{fc};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
    }

    public void testReceptionOfAllMessages() {
        int num_received = 0;
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        for (int i = 1; i <= 100000; ++i) {
            Message msg = new Message(null, null, FCTest.createPayload(1000));
            Event evt = new Event(1, msg);
            this.s.send(evt);
            if (i % 1000 != 0) continue;
            System.out.println("==> " + i);
        }
        for (int num_tries = 10; num_tries > 0; --num_tries) {
            Util.sleep(1000L);
            num_received = r.getNumberOfReceivedMessages();
            System.out.println("-- num received=" + num_received + ", stats:\n" + this.s.dumpStats());
            if (num_received >= 100000) break;
        }
        FCTest.assertEquals((int)num_received, (int)100000);
    }

    private static byte[] createPayload(int size) {
        byte[] retval = new byte[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = 48;
        }
        return retval;
    }

    public static Test suite() {
        return new TestSuite(FCTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FCTest.suite());
    }

    static class Receiver
    implements Simulator.Receiver {
        int num_mgs_received = 0;

        Receiver() {
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.num_mgs_received;
                if (this.num_mgs_received % 1000 == 0) {
                    System.out.println("<== " + this.num_mgs_received);
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }
}

