/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;

public class QueueTest2 {
    Queueable q = null;
    long start;
    long stop;
    long NUM = 1000000L;

    void start(Queueable q, String msg) throws Exception {
        this.q = q;
        System.out.println("-- starting test with " + q.getClass() + " (" + msg + ')');
        this.start = System.currentTimeMillis();
        Adder adder = new Adder();
        Remover remover = new Remover();
        remover.start();
        adder.start();
        adder.join();
        remover.join();
        System.out.println("-- done with " + q.getClass());
        System.out.println(" total time for " + this.NUM + " elements: " + (this.stop - this.start) + " msecs\n\n");
    }

    public static void main(String[] args) {
        try {
            QueueTest2 qt = new QueueTest2();
            Queueable q = new JgQueue();
            qt.start(q, "based on org.jgroups.util.Queue");
            q = new MyQueue();
            qt.start(q, "based on java.util.LinkedList");
            q = new MyLinkedQueue();
            qt.start(q, "java.util.concurrent.ConcurrentLinkedList");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class MyLinkedQueue
    implements Queueable {
        ConcurrentLinkedQueue q = new ConcurrentLinkedQueue();

        public void addElement(Object o) {
            this.q.add(o);
        }

        public Object removeElement() {
            return this.q.poll();
        }
    }

    public static class MyQueue
    extends LinkedList
    implements Queueable {
        final Object mutex = new Object();
        boolean waiting = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                super.add(o);
                if (this.waiting) {
                    this.mutex.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object removeElement() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.size() > 0) {
                    return this.removeFirst();
                }
                this.waiting = true;
                try {
                    try {
                        this.mutex.wait();
                        Object e = this.removeFirst();
                        Object var5_4 = null;
                        this.waiting = false;
                        return e;
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                        Object var3_7 = null;
                        Object var5_5 = null;
                        this.waiting = false;
                        return var3_7;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.waiting = false;
                    throw throwable;
                }
            }
        }
    }

    public static class JgQueue
    extends Queue
    implements Queueable {
        public void addElement(Object o) {
            try {
                this.add(o);
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
            }
        }

        public Object removeElement() {
            try {
                return this.remove();
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    class Remover
    extends Thread {
        int i = 0;

        Remover() {
        }

        public void run() {
            do {
                try {
                    if (QueueTest2.this.q.removeElement() != null) {
                        ++this.i;
                        continue;
                    }
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while ((long)this.i < QueueTest2.this.NUM);
            QueueTest2.this.stop = System.currentTimeMillis();
        }
    }

    class Adder
    extends Thread {
        Adder() {
        }

        public void run() {
            int i = 0;
            while ((long)i < QueueTest2.this.NUM) {
                try {
                    QueueTest2.this.q.addElement(new Integer(i));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static interface Queueable {
        public void addElement(Object var1);

        public Object removeElement();
    }
}

