/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.servlet.http.Cookie;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.ExtendedFormAuthenticator;

public class GenericHeaderAuthenticator
extends ExtendedFormAuthenticator {
    protected static Logger log = Logger.getLogger(GenericHeaderAuthenticator.class);
    protected boolean trace = log.isTraceEnabled();
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;

    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    public void setHttpHeaderForSSOAuth(String httpHeaderForSSOAuth) {
        this.httpHeaderForSSOAuth = httpHeaderForSSOAuth;
    }

    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    public void setSessionCookieForSSOAuth(String sessionCookieForSSOAuth) {
        this.sessionCookieForSSOAuth = sessionCookieForSSOAuth;
    }

    public boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        log.trace((Object)"Authenticating user");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (this.trace) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        Realm realm = this.context.getRealm();
        Session session = request.getSessionInternal(true);
        String username = this.getUserId(request);
        String password = this.getSessionCookie(request);
        if (username == null || password == null) {
            log.trace((Object)"Username is null or password(sessionkey) is null:fallback to form auth");
            return super.authenticate(request, response, config);
        }
        principal = realm.authenticate(username, password);
        if (principal == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
        request.setUserPrincipal(principal);
        this.register(request, response, principal, "FORM", username, password);
        return true;
    }

    protected String getUserId(Request request) {
        String ids;
        String ssoid;
        block5: {
            ssoid = null;
            ids = "";
            try {
                ids = this.getIdentityHeaderId();
            }
            catch (JMException e) {
                if (!this.trace) break block5;
                log.trace((Object)"getUserId exception", (Throwable)e);
            }
        }
        if (ids == null || ids.length() == 0) {
            throw new IllegalStateException("Http headers configuration in tomcat service missing");
        }
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens() && (ssoid = request.getHeader(st.nextToken())) == null) {
        }
        if (this.trace) {
            log.trace((Object)("SSOID-" + ssoid));
        }
        return ssoid;
    }

    protected String getSessionCookie(Request request) {
        String ids;
        int numCookies;
        Cookie[] cookies;
        block5: {
            cookies = request.getCookies();
            log.trace((Object)("Cookies:" + cookies));
            numCookies = cookies != null ? cookies.length : 0;
            ids = "";
            try {
                ids = this.getSessionCookieId();
                log.trace((Object)("Session Cookie Ids=" + ids));
            }
            catch (JMException e) {
                if (!this.trace) break block5;
                log.trace((Object)"checkSessionCookie exception", (Throwable)e);
            }
        }
        if (ids == null || ids.length() == 0) {
            throw new IllegalStateException("Session cookies configuration in tomcat service missing");
        }
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens()) {
            String cookieToken = st.nextToken();
            String val = this.getCookieValue(cookies, numCookies, cookieToken);
            if (val == null) continue;
            return val;
        }
        if (this.trace) {
            log.trace((Object)"Session Cookie not found");
        }
        return null;
    }

    protected String getIdentityHeaderId() throws JMException {
        if (this.httpHeaderForSSOAuth != null) {
            return this.httpHeaderForSSOAuth;
        }
        return (String)this.mserver.getAttribute(new ObjectName("jboss.web:service=WebServer"), "HttpHeaderForSSOAuth");
    }

    protected String getSessionCookieId() throws JMException {
        if (this.sessionCookieForSSOAuth != null) {
            return this.sessionCookieForSSOAuth;
        }
        return (String)this.mserver.getAttribute(new ObjectName("jboss.web:service=WebServer"), "SessionCookieForSSOAuth");
    }

    protected String getCookieValue(Cookie[] cookies, int numCookies, String token) {
        for (int i = 0; i < numCookies; ++i) {
            Cookie cookie = cookies[i];
            log.trace((Object)("Matching cookieToken:" + token + " with cookie name=" + cookie.getName()));
            if (!token.equals(cookie.getName())) continue;
            if (this.trace) {
                log.trace((Object)("Cookie-" + token + " value=" + cookie.getValue()));
            }
            return cookie.getValue();
        }
        return null;
    }
}

