/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.managed;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.plugins.managed.SecurityActions;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectClass;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataICF
implements InstanceClassFactory<BeanMetaData> {
    private static final Logger log = Logger.getLogger(BeanMetaDataICF.class);
    private KernelController controller;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private InstanceClassFactory delegateICF;

    public KernelController getController() {
        return this.controller;
    }

    public void setController(KernelController controller) {
        this.controller = controller;
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public InstanceClassFactory getDelegateICF() {
        return this.delegateICF;
    }

    public void setDelegateICF(InstanceClassFactory delegateICF) {
        this.delegateICF = delegateICF;
    }

    public Object locateBean(String beanName) {
        ControllerContext context = this.getController().getInstalledContext((Object)beanName);
        if (context == null) {
            return null;
        }
        return context.getTarget();
    }

    public Class<BeanMetaData> getType() {
        return BeanMetaData.class;
    }

    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, BeanMetaData attachment, MetaValue value) {
        return attachment.getName();
    }

    public Class<?> getManagedObjectClass(BeanMetaData attachment) throws ClassNotFoundException {
        String beanClassName;
        Class<?> mocClass = null;
        Set annotations = attachment.getAnnotations();
        if (annotations != null) {
            for (AnnotationMetaData amd : annotations) {
                Annotation ann = amd.getAnnotationInstance();
                if (!(ann instanceof ManagementObjectClass)) continue;
                ManagementObjectClass moc = (ManagementObjectClass)ann;
                mocClass = moc.code();
                log.debug((Object)("Saw ManagementObjectClass, " + mocClass + " for bean: " + attachment));
                break;
            }
        }
        if (mocClass == null && (beanClassName = attachment.getBean()) != null && beanClassName.length() > 0) {
            ClassLoader loader = this.getClassLoader(attachment);
            mocClass = loader.loadClass(beanClassName);
            ManagementObject moAnn = mocClass.getAnnotation(ManagementObject.class);
            if (moAnn == null) {
                mocClass = attachment.getClass();
            }
            log.debug((Object)("Using bean class:, " + mocClass + " for bean: " + attachment));
        }
        return mocClass;
    }

    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, MetaData metaData, BeanMetaData attachment) {
        PropertyInfo propertyInfo;
        String name = property.getMappedName();
        if (name == null) {
            name = property.getName();
        }
        if ((propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class)) == null) {
            propertyInfo = beanInfo.getProperty(name);
        }
        Object bean = this.locateBean(attachment.getName());
        MetaValue mvalue = null;
        if (!propertyInfo.isReadable()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping get of non-readable property: " + propertyInfo));
            }
            return null;
        }
        try {
            String getterClassName = propertyInfo.getGetter().getDeclaringClass().getName();
            if (getterClassName.equals(attachment.getClass().getName())) {
                mvalue = this.delegateICF.getValue(beanInfo, property, metaData, (Object)attachment);
            } else if (bean != null) {
                mvalue = this.delegateICF.getValue(beanInfo, property, metaData, bean);
            } else {
                PropertyMetaData md = null;
                if (attachment.getProperties() != null && !attachment.getProperties().isEmpty()) {
                    for (PropertyMetaData bp : attachment.getProperties()) {
                        if (!name.equals(bp.getName())) continue;
                        md = bp;
                        break;
                    }
                    if (md != null && md.getValue() != null) {
                        mvalue = this.metaValueFactory.create(md.getValue().getUnderlyingValue(), propertyInfo.getType());
                    }
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Failed to get property value for bean: " + beanInfo.getName() + ", property: " + propertyInfo.getName()), e);
            mvalue = this.metaValueFactory.create(null, propertyInfo.getType());
            return mvalue;
        }
        return mvalue;
    }

    public void setValue(BeanInfo beanInfo, ManagedProperty property, BeanMetaData attachment, MetaValue value) {
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        String beanName = attachment.getName();
        String name = property.getMappedName();
        if (name == null) {
            name = property.getName();
        }
        try {
            ClassLoader loader = this.getClassLoader(attachment);
            SecurityActions.setContextClassLoader(loader);
            PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
            if (propertyInfo == null) {
                propertyInfo = beanInfo.getProperty(name);
            }
            if (propertyInfo == null) {
                throw new IllegalArgumentException("No matching property found: " + name + "/" + beanName);
            }
            if (!propertyInfo.isWritable()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Skipping get of non-writable property: " + propertyInfo));
                }
                return;
            }
            Object plainValue = this.unwrapValue(property, propertyInfo.getType(), value);
            Object bean = this.locateBean(beanName);
            if (bean != null) {
                propertyInfo.set(bean, plainValue);
            }
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)attachment);
            builder.addPropertyMetaData(name, plainValue);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to set property value: " + name + "/" + beanName, e);
        }
        finally {
            SecurityActions.setContextClassLoader(prevLoader);
        }
    }

    protected ClassLoader getClassLoader(BeanMetaData bmd) {
        ClassLoader loader = null;
        try {
            loader = Configurator.getClassLoader((BeanMetaData)bmd);
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to load BeanMetaData class loader", t);
        }
        if (loader == null) {
            loader = SecurityActions.getContextClassLoader();
        }
        return loader;
    }

    private Object unwrapValue(ManagedProperty property, TypeInfo typeInfo, MetaValue value) {
        MetaMapper metaMapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class);
        if (metaMapper != null) {
            return metaMapper.unwrapMetaValue(value);
        }
        return this.metaValueFactory.unwrap(value, typeInfo);
    }
}

