/*
 * Decompiled with CFR 0.152.
 */
package mazz.i18n;

import java.util.Locale;

public class LoggerLocale {
    public static final String LOG_LOCALE_SYSTEM_PROPERTY = "i18nlog.log-locale";
    public static final String LOG_LOCALE_IS_DEFAULT_SYSTEM_PROPERTY = "i18nlog.log-locale-is-default";
    private static Locale s_logLocale = null;

    public static Locale getLogLocale() {
        if (s_logLocale != null) {
            return s_logLocale;
        }
        String locale_prop = null;
        boolean locale_is_default_prop = false;
        try {
            locale_prop = System.getProperty(LOG_LOCALE_SYSTEM_PROPERTY);
            locale_is_default_prop = Boolean.getBoolean(LOG_LOCALE_IS_DEFAULT_SYSTEM_PROPERTY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_logLocale = LoggerLocale.parseLocaleString(locale_prop, locale_is_default_prop);
        return s_logLocale;
    }

    public static void setLogLocale(Locale locale) {
        s_logLocale = locale;
    }

    public static void setLogLocale(String locale_str) {
        s_logLocale = LoggerLocale.parseLocaleString(locale_str, false);
    }

    public static void reset() {
        s_logLocale = null;
        LoggerLocale.getLogLocale();
    }

    private static Locale parseLocaleString(String locale_str, boolean locale_is_default) {
        Locale log_locale;
        if (locale_str != null) {
            String[] locale_specs = locale_str.split("_");
            String language = locale_specs.length > 0 ? locale_specs[0] : "";
            String country = locale_specs.length > 1 ? locale_specs[1] : "";
            String variant = locale_specs.length > 2 ? locale_specs[2] : "";
            log_locale = new Locale(language, country, variant);
        } else {
            log_locale = locale_is_default ? Locale.getDefault() : Locale.ENGLISH;
        }
        return log_locale;
    }
}

