/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.agent;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.rhq.core.pc.agent.AgentServiceLifecycleListener;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;

public abstract class AgentService {
    private Class clientInterface;
    private Collection<AgentServiceLifecycleListener> listeners;
    private AgentServiceStreamRemoter streamRemoter;

    protected AgentService(Class clientInterface) {
        this.clientInterface = clientInterface;
        this.listeners = new LinkedHashSet<AgentServiceLifecycleListener>();
    }

    public void notifyLifecycleListenersOfNewState(LifecycleState newState) {
        for (AgentServiceLifecycleListener agentServiceLifecycleListener : this.listeners) {
            switch (newState) {
                case STARTED: {
                    agentServiceLifecycleListener.started(this);
                    break;
                }
                case STOPPED: {
                    agentServiceLifecycleListener.stopped(this);
                }
            }
        }
    }

    protected InputStream remoteInputStream(InputStream inputStream) {
        if (inputStream == null || this.streamRemoter == null) {
            return inputStream;
        }
        return this.streamRemoter.prepareInputStream(inputStream);
    }

    protected OutputStream remoteOutputStream(OutputStream outputStream) {
        if (outputStream == null || this.streamRemoter == null) {
            return outputStream;
        }
        return this.streamRemoter.prepareOutputStream(outputStream);
    }

    public void addLifecycleListener(AgentServiceLifecycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeLifecycleListener(AgentServiceLifecycleListener listener) {
        this.listeners.remove(listener);
    }

    public void setAgentServiceStreamRemoter(AgentServiceStreamRemoter remoter) {
        this.streamRemoter = remoter;
    }

    public Class getClientInterface() {
        return this.clientInterface;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LifecycleState {
        STARTED,
        STOPPED;

    }
}

