/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;
import org.richfaces.component.UIToolTip;

public abstract class ToolTipTagBase
extends HtmlComponentTagBase {
    private boolean _showEventSet = false;
    private ValueExpression _event = null;

    private void logValueDeprecation(ValueExpression event) {
        FacesContext facesContext = this.getFacesContext();
        facesContext.getExternalContext().log("showEvent attribute has been already set for component with id: " + this.getId() + "[" + event.getExpressionString() + "]. event attribute is deprecated and thus has been dropped!");
    }

    public void setShowEvent(ValueExpression event) {
        if (!this._showEventSet && this._event != null) {
            this.logValueDeprecation(event);
        }
        this._event = event;
        this._showEventSet = true;
    }

    public void setEvent(ValueExpression event) {
        if (!this._showEventSet) {
            this._event = event;
        } else {
            this.logValueDeprecation(this._event);
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        if (this._event != null) {
            if (this._event.isLiteralText()) {
                UIToolTip toolTip = (UIToolTip)component;
                try {
                    toolTip.setShowEvent(this._event.getExpressionString());
                }
                catch (ELException e) {
                    throw new FacesException((Throwable)e);
                }
            } else {
                component.setValueExpression("showEvent", this._event);
            }
        }
    }

    public void release() {
        super.release();
        this._showEventSet = false;
        this._event = null;
    }
}

