/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class InternalInputBuffer
implements InputBuffer {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean swallowInput;
    protected byte[] buf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected InputStream inputStream;
    protected InputBuffer inputStreamInputBuffer;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;

    public InternalInputBuffer(Request request) {
        this(request, 49152);
    }

    public InternalInputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.inputStreamInputBuffer = new InputStreamInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void addFilter(InputFilter filter) {
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new InputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    public void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    public void recycle() {
        this.request.recycle();
        this.inputStream = null;
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0) {
            int npos = 0;
            int opos = this.pos;
            while (this.lastValid - opos > opos - npos) {
                System.arraycopy(this.buf, opos, this.buf, npos, opos - npos);
                npos += this.pos;
                opos += this.pos;
            }
            System.arraycopy(this.buf, opos, this.buf, npos, this.lastValid - opos);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    public void parseRequestLine() throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.pos < this.lastValid || this.fill()) continue;
            throw new EOFException(sm.getString("iib.eof.error"));
        } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
        --this.pos;
        start = this.pos;
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                eol = true;
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                questionPos = this.pos;
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 13) {
                end = this.pos;
            } else if (this.buf[this.pos] == 10) {
                if (end == 0) {
                    end = this.pos;
                }
                eol = true;
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        } else {
            this.request.protocol().setString("");
        }
    }

    public void parseHeaders() throws IOException {
        while (this.parseHeader()) {
        }
        this.parsingHeader = false;
        this.end = this.pos;
    }

    public boolean parseHeader() throws IOException {
        byte chr = 0;
        while (true) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            chr = this.buf[this.pos];
            if (chr != 13 && chr != 10) break;
            if (chr == 10) {
                ++this.pos;
                return false;
            }
            ++this.pos;
        }
        int start = this.pos;
        boolean colon = false;
        MessageBytes headerValue = null;
        while (!colon) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 58) {
                colon = true;
                headerValue = this.headers.addValue(this.buf, start, this.pos - start);
            }
            if ((chr = this.buf[this.pos]) >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
        }
        start = this.pos;
        int realPos = this.pos;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            int lastSignificantChar = realPos;
            while (!eol) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos] == 10) {
                        eol = true;
                    } else if (this.buf[this.pos] == 32) {
                        this.buf[realPos] = this.buf[this.pos];
                        ++realPos;
                    } else {
                        this.buf[realPos] = this.buf[this.pos];
                        lastSignificantChar = ++realPos;
                    }
                }
                ++this.pos;
            }
            realPos = lastSignificantChar;
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            chr = this.buf[this.pos];
            if (chr != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.buf[realPos] = chr;
            ++realPos;
        }
        headerValue.setBytes(this.buf, start, realPos - start);
        return true;
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk, req);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    protected boolean fill() throws IOException {
        int nRead = 0;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            nRead = this.inputStream.read(this.buf, this.pos, this.buf.length - this.lastValid);
            if (nRead > 0) {
                this.lastValid = this.pos + nRead;
            }
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            nRead = this.inputStream.read(this.buf, this.pos, this.buf.length - this.lastValid);
            if (nRead > 0) {
                this.lastValid = this.pos + nRead;
            }
        }
        return nRead > 0;
    }

    protected class InputStreamInputBuffer
    implements InputBuffer {
        protected InputStreamInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalInputBuffer.this.pos >= InternalInputBuffer.this.lastValid && !InternalInputBuffer.this.fill()) {
                return -1;
            }
            int length = InternalInputBuffer.this.lastValid - InternalInputBuffer.this.pos;
            chunk.setBytes(InternalInputBuffer.this.buf, InternalInputBuffer.this.pos, length);
            InternalInputBuffer.this.pos = InternalInputBuffer.this.lastValid;
            return length;
        }
    }
}

