/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.jboss.ws.util.xml.BufferedStreamSource;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;

public class XMLFragment {
    private static Logger log = Logger.getLogger(XMLFragment.class);
    private Source source;
    private static final String XML_PROC = "<?xml";
    private RuntimeException streamSourceAccessMarker;

    public XMLFragment(Source source) {
        this.source = source;
    }

    public XMLFragment(String xmlString) {
        this.source = new BufferedStreamSource(xmlString.getBytes());
    }

    public XMLFragment(Result result) {
        if (result instanceof DOMResult) {
            DOMResult domResult = (DOMResult)result;
            this.source = new DOMSource(domResult.getNode());
        } else if (result instanceof BufferedStreamResult) {
            BufferedStreamResult br = (BufferedStreamResult)result;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)br.getOutputStream();
            this.source = new BufferedStreamSource(baos.toByteArray());
        } else {
            throw new IllegalArgumentException("Unsupported result type: " + result);
        }
    }

    public Source getSource() {
        this.source = this.beginSourceAccess(this.source);
        this.endSourceAccess();
        return this.source;
    }

    public String toXMLString() {
        try {
            StringWriter strWriter = new StringWriter(1024);
            this.writeSourceInternal(strWriter);
            return strWriter.toString();
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    public Element toElement() {
        Element retElement = null;
        try {
            this.source = this.beginSourceAccess(this.source);
            retElement = DOMUtils.sourceToElement((Source)this.source);
            this.endSourceAccess();
        }
        catch (IOException ex) {
            this.handleSourceAccessException(ex);
        }
        return retElement;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeSourceInternal(writer);
    }

    public void writeTo(OutputStream out) throws IOException {
        PrintWriter printWriter = new PrintWriter(out);
        this.writeSourceInternal(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private void writeSourceInternal(Writer writer) throws IOException {
        try {
            this.source = this.beginSourceAccess(this.source);
            if (this.source instanceof DOMSource) {
                DOMSource domSource = (DOMSource)this.source;
                new DOMWriter(writer).print(domSource.getNode());
            } else if (this.source instanceof StreamSource || this.source instanceof SAXSource) {
                StreamSource streamSource = (StreamSource)this.source;
                boolean newReader = false;
                Reader reader = streamSource.getReader();
                if (reader == null) {
                    reader = new InputStreamReader(streamSource.getInputStream(), "UTF-8");
                    newReader = true;
                }
                char[] cbuf = new char[1024];
                int len = reader.read(cbuf);
                int off = 0;
                if (len == -1) {
                    throw new IOException("StreamSource already exhausted");
                }
                String xmlProc = new String(cbuf, 0, XML_PROC.length());
                if (XML_PROC.equals(xmlProc)) {
                    for (off = XML_PROC.length(); cbuf[off] != '>' && off < len; ++off) {
                    }
                    if (cbuf[off] != '>') {
                        throw new IllegalStateException("Cannot find end of XML processing instruction");
                    }
                    len -= ++off;
                }
                while (len > 0) {
                    writer.write(cbuf, off, len);
                    len = reader.read(cbuf);
                    off = 0;
                }
                if (newReader) {
                    reader.close();
                }
            } else {
                throw new IllegalArgumentException("Unsupported source type: " + this.source);
            }
            this.endSourceAccess();
        }
        catch (IOException ex) {
            this.handleSourceAccessException(ex);
        }
    }

    private Source beginSourceAccess(Source source) {
        if (source instanceof BufferedStreamSource || source instanceof DOMSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            source = new BufferedStreamSource((StreamSource)source);
        } else {
            try {
                Element element = DOMUtils.sourceToElement((Source)source);
                source = new DOMSource(element);
            }
            catch (IOException ex) {
                WSException.rethrow(ex);
            }
        }
        return source;
    }

    private void endSourceAccess() {
        if (this.source instanceof StreamSource) {
            this.streamSourceAccessMarker = new RuntimeException();
        }
    }

    private void handleSourceAccessException(IOException ex) {
        if (this.source instanceof StreamSource && this.streamSourceAccessMarker != null) {
            log.error((Object)"StreamSource was previously accessed from", (Throwable)this.streamSourceAccessMarker);
        }
        WSException.rethrow(ex);
    }

    public String toString() {
        return "[source=" + this.source + "]";
    }
}

