/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMIncompleteSequenceBehavior;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMCreateSequenceResponseSerializer
implements RMSerializer {
    private static final AddressingConstants ADDRESSING_CONSTANTS = AddressingBuilder.getAddressingBuilder().newAddressingConstants();
    private static final RMSerializer INSTANCE = new RMCreateSequenceResponseSerializer();

    private RMCreateSequenceResponseSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCreateSequenceResponse o = (RMCreateSequenceResponse)object;
        try {
            QName acceptQName;
            SOAPElement acceptElement;
            QName behaviorQName;
            SOAPElement behaviorElement;
            SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
            RMConstants wsrmConstants = provider.getConstants();
            QName createSequenceResponseQName = wsrmConstants.getCreateSequenceResponseQName();
            SOAPElement createSequenceResponseElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapBody, createSequenceResponseQName, "soap body");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(createSequenceResponseElement, identifierQName, createSequenceResponseQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
            QName expiresQName = wsrmConstants.getExpiresQName();
            SOAPElement expiresElement = RMSerializationHelper.getOptionalElement(createSequenceResponseElement, expiresQName, createSequenceResponseQName);
            if (expiresElement != null) {
                String duration = RMSerializationHelper.getRequiredTextContent(expiresElement, expiresQName);
                o.setExpires(RMHelper.stringToDuration(duration));
            }
            if ((behaviorElement = RMSerializationHelper.getOptionalElement(createSequenceResponseElement, behaviorQName = wsrmConstants.getIncompleteSequenceBehaviorQName(), createSequenceResponseQName)) != null) {
                String behaviorString = RMSerializationHelper.getRequiredTextContent(behaviorElement, behaviorQName);
                o.setIncompleteSequenceBehavior(RMIncompleteSequenceBehavior.getValue(behaviorString));
            }
            if ((acceptElement = RMSerializationHelper.getOptionalElement(createSequenceResponseElement, acceptQName = wsrmConstants.getAcceptQName(), createSequenceResponseQName)) != null) {
                RMCreateSequenceResponse.RMAccept accept = o.newAccept();
                QName acksToQName = wsrmConstants.getAcksToQName();
                SOAPElement acksToElement = RMSerializationHelper.getRequiredElement(acceptElement, acksToQName, acceptQName);
                QName addressQName = ADDRESSING_CONSTANTS.getAddressQName();
                SOAPElement acksToAddressElement = RMSerializationHelper.getRequiredElement(acksToElement, addressQName, acksToQName);
                String acksToAddress = RMSerializationHelper.getRequiredTextContent(acksToAddressElement, addressQName);
                accept.setAcksTo(acksToAddress);
                o.setAccept(accept);
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCreateSequenceResponse o = (RMCreateSequenceResponse)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName createSequenceResponseQName = wsrmConstants.getCreateSequenceResponseQName();
            SOAPElement createSequenceResponseElement = soapEnvelope.getBody().addChildElement(createSequenceResponseQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            createSequenceResponseElement.addChildElement(identifierQName).setValue(o.getIdentifier());
            if (o.getExpires() != null) {
                QName expiresQName = wsrmConstants.getExpiresQName();
                createSequenceResponseElement.addChildElement(expiresQName).setValue(RMHelper.durationToString(o.getExpires()));
            }
            if (o.getIncompleteSequenceBehavior() != null) {
                RMIncompleteSequenceBehavior behavior = o.getIncompleteSequenceBehavior();
                QName behaviorQName = wsrmConstants.getIncompleteSequenceBehaviorQName();
                SOAPElement behaviorElement = createSequenceResponseElement.addChildElement(behaviorQName);
                behaviorElement.setValue(behavior.toString());
            }
            if (o.getAccept() != null) {
                QName acceptQName = wsrmConstants.getAcceptQName();
                SOAPElement acceptElement = createSequenceResponseElement.addChildElement(acceptQName);
                QName acksToQName = wsrmConstants.getAcksToQName();
                QName addressQName = ADDRESSING_CONSTANTS.getAddressQName();
                acceptElement.addChildElement(acksToQName).addChildElement(addressQName).setValue(o.getAccept().getAcksTo());
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

