/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jaxb.intros.configmodel.ClassIntroConfig;
import org.jboss.jaxb.intros.configmodel.ClassMemberIntroConfig;
import org.jboss.jaxb.intros.configmodel.FieldIntroConfig;
import org.jboss.jaxb.intros.configmodel.JaxbIntros;
import org.jboss.jaxb.intros.configmodel.MethodIntroConfig;
import org.jboss.jaxb.intros.configmodel.XmlAccessorTypeIntro;
import org.jboss.jaxb.intros.configmodel.XmlAttributeIntro;
import org.jboss.jaxb.intros.configmodel.XmlElementIntro;
import org.jboss.jaxb.intros.configmodel.XmlRootElementIntro;
import org.jboss.jaxb.intros.configmodel.XmlTypeIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;
import org.jboss.jaxb.intros.handlers.XmlAccessorTypeHandler;
import org.jboss.jaxb.intros.handlers.XmlAttributeHandler;
import org.jboss.jaxb.intros.handlers.XmlElementHandler;
import org.jboss.jaxb.intros.handlers.XmlRootElementHandler;
import org.jboss.jaxb.intros.handlers.XmlTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroductionsAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private static final Log logger = LogFactory.getLog(IntroductionsAnnotationReader.class);
    private RuntimeAnnotationReader baseReader = new RuntimeInlineAnnotationReader();
    private JaxbIntros introductions;
    private static Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    public IntroductionsAnnotationReader(JaxbIntros introductions) {
        if (introductions == null) {
            throw new IllegalArgumentException("arg 'introductions' is null.");
        }
        this.introductions = introductions;
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation, Field field, Locatable srcPos) {
        Annotation proxy = this.getProxy(annotation, field);
        if (proxy != null) {
            return (A)proxy;
        }
        return (A)LocatableAnnotation.create(field.getAnnotation(annotation), (Locatable)srcPos);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field) {
        FieldIntroConfig fieldIntroConfig = this.getFieldIntroConfig(field);
        if (fieldIntroConfig != null) {
            return this.isMemberAnnotationIntroAvailable(annotationType, fieldIntroConfig);
        }
        return field.isAnnotationPresent(annotationType);
    }

    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        return this.getAllAnnotations(field, srcPos);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation, Method method, Locatable srcPos) {
        Annotation proxy = this.getProxy(annotation, method);
        if (proxy != null) {
            return (A)proxy;
        }
        return (A)LocatableAnnotation.create(method.getAnnotation(annotation), (Locatable)srcPos);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> annotation, Method method) {
        MethodIntroConfig methodAnnotations = this.getMethodIntroConfig(method);
        if (methodAnnotations != null) {
            return this.isMemberAnnotationIntroAvailable(annotation, methodAnnotations);
        }
        return method.isAnnotationPresent(annotation);
    }

    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        return this.getAllAnnotations(method, srcPos);
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        return (A)this.baseReader.getMethodParameterAnnotation(annotation, (Object)method, paramIndex, srcPos);
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> annotation, Class clazz, Locatable srcPos) {
        Annotation proxy = this.getProxy(annotation, clazz);
        if (proxy != null) {
            return (A)proxy;
        }
        return (A)LocatableAnnotation.create(clazz.getAnnotation(annotation), (Locatable)srcPos);
    }

    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> annotationType) {
        ClassIntroConfig classAnnotations = this.getClassIntroConfig(clazz);
        if (classAnnotations != null) {
            return this.isClassAnnotationIntroAvailable(annotationType, classAnnotations);
        }
        return clazz.isAnnotationPresent(annotationType);
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        return (A)this.baseReader.getPackageAnnotation(a, (Object)clazz, srcPos);
    }

    public Class getClassValue(Annotation a, String name) {
        if (a instanceof ClassValue) {
            return ((ClassValue)((Object)a)).getClassValue(a, name);
        }
        return (Class)this.baseReader.getClassValue(a, name);
    }

    public Class[] getClassArrayValue(Annotation a, String name) {
        if (a instanceof ClassValue) {
            return ((ClassValue)((Object)a)).getClassArrayValue(a, name);
        }
        return (Class[])this.baseReader.getClassArrayValue(a, name);
    }

    protected String fullName(Method m) {
        return m.getDeclaringClass().getName() + '#' + m.getName();
    }

    private ClassIntroConfig getClassIntroConfig(Class clazz) {
        String className = clazz.getName();
        ClassIntroConfig globalIntro = null;
        for (ClassIntroConfig classIntro : this.introductions.getClazz()) {
            if (classIntro.getName().equals(className)) {
                return classIntro;
            }
            if (globalIntro != null || !this.isRegexMatch(className, classIntro.getName())) continue;
            globalIntro = classIntro;
        }
        return globalIntro;
    }

    private FieldIntroConfig getFieldIntroConfig(Field field) {
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(field.getDeclaringClass());
        if (classIntroConfig != null) {
            String fieldName = field.getName();
            for (FieldIntroConfig fieldIntro : classIntroConfig.getField()) {
                if (fieldIntro.getName().equals(fieldName)) {
                    return fieldIntro;
                }
                if (!this.isRegexMatch(fieldName, fieldIntro.getName())) continue;
                return fieldIntro;
            }
        }
        return null;
    }

    private MethodIntroConfig getMethodIntroConfig(Method method) {
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(method.getDeclaringClass());
        if (classIntroConfig != null) {
            String methodName = method.getName();
            for (MethodIntroConfig methodIntro : classIntroConfig.getMethod()) {
                if (methodIntro.getName().equals(methodName)) {
                    return methodIntro;
                }
                if (!this.isRegexMatch(methodName, methodIntro.getName())) continue;
                return methodIntro;
            }
        }
        return null;
    }

    private boolean isRegexMatch(String string, String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(regex);
            }
            catch (Exception e) {
                logger.warn((Object)("Error compiling '" + regex + "' as a regular expression: " + e.getMessage()));
                return false;
            }
            patternCache.put(regex, pattern);
        }
        return pattern.matcher(string).matches();
    }

    private Annotation getMemberAnnotationProxy(Class annotation, ClassMemberIntroConfig memberIntroConfig) {
        XmlElementIntro xmlElementIntro;
        Annotation proxy = null;
        if (annotation == XmlAttribute.class) {
            XmlAttributeIntro xmlAttributeIntro = memberIntroConfig.getXmlAttribute();
            if (xmlAttributeIntro != null) {
                proxy = XmlAttributeHandler.createProxy(xmlAttributeIntro);
            }
        } else if (annotation == XmlElement.class && (xmlElementIntro = memberIntroConfig.getXmlElement()) != null) {
            proxy = XmlElementHandler.createProxy(xmlElementIntro);
        }
        return proxy;
    }

    private Annotation getClassAnnotationProxy(Class annotation, ClassIntroConfig classIntroConfig) {
        XmlRootElementIntro xmlRootElementIntro;
        Annotation proxy = null;
        if (annotation == XmlAccessorType.class) {
            XmlAccessorTypeIntro xmlAccessorTypeIntro = classIntroConfig.getXmlAccessorType();
            if (xmlAccessorTypeIntro != null) {
                proxy = XmlAccessorTypeHandler.createProxy(xmlAccessorTypeIntro);
            }
        } else if (annotation == XmlType.class) {
            XmlTypeIntro xmlTypeIntro = classIntroConfig.getXmlType();
            if (xmlTypeIntro != null) {
                proxy = XmlTypeHandler.createProxy(xmlTypeIntro);
            }
        } else if (annotation == XmlRootElement.class && (xmlRootElementIntro = classIntroConfig.getXmlRootElement()) != null) {
            proxy = XmlRootElementHandler.createProxy(xmlRootElementIntro);
        }
        return proxy;
    }

    private boolean isMemberAnnotationIntroAvailable(Class<? extends Annotation> annotation, ClassMemberIntroConfig memberIntroConfig) {
        if (annotation == XmlAttribute.class) {
            return memberIntroConfig.getXmlAttribute() != null;
        }
        if (annotation == XmlElement.class) {
            return memberIntroConfig.getXmlElement() != null;
        }
        return false;
    }

    private boolean isClassAnnotationIntroAvailable(Class<? extends Annotation> annotation, ClassIntroConfig classIntroConfig) {
        if (annotation == XmlType.class) {
            return classIntroConfig.getXmlType() != null;
        }
        if (annotation == XmlAccessorType.class) {
            return classIntroConfig.getXmlAccessorType() != null;
        }
        if (annotation == XmlRootElement.class) {
            return classIntroConfig.getXmlRootElement() != null;
        }
        return false;
    }

    private Annotation[] getAllAnnotations(Member member, Locatable srcPos) {
        Annotation[] r = ((AnnotatedElement)((Object)member)).getAnnotations();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < r.length; ++i) {
            Class<?> annType = r[i].getClass();
            if (annType == XmlAttribute.class || annType == XmlElement.class) continue;
            annotations.add(LocatableAnnotation.create((Annotation)r[i], (Locatable)srcPos));
        }
        ClassMemberIntroConfig memberIntroConfig = null;
        if (member instanceof Field) {
            memberIntroConfig = this.getFieldIntroConfig((Field)member);
        } else if (member instanceof Method) {
            memberIntroConfig = this.getMethodIntroConfig((Method)member);
        }
        if (memberIntroConfig != null) {
            this.addMemberAnnotation(XmlAttribute.class, memberIntroConfig, annotations, member, srcPos);
            this.addMemberAnnotation(XmlElement.class, memberIntroConfig, annotations, member, srcPos);
        }
        r = annotations.toArray(new Annotation[annotations.size()]);
        return r;
    }

    private void addMemberAnnotation(Class annotationType, ClassMemberIntroConfig memberIntroConfig, List<Annotation> annotations, Member member, Locatable srcPos) {
        Annotation annotation = this.getMemberAnnotationProxy(annotationType, memberIntroConfig);
        if (annotation != null) {
            annotations.add(annotation);
        } else {
            annotation = ((AnnotatedElement)((Object)member)).getAnnotation(annotationType);
            if (annotation != null) {
                annotations.add(LocatableAnnotation.create((Annotation)annotation, (Locatable)srcPos));
            }
        }
    }

    private Annotation getProxy(Class annotation, Field field) {
        Annotation proxy;
        FieldIntroConfig fieldIntroConfig = this.getFieldIntroConfig(field);
        if (fieldIntroConfig != null && (proxy = this.getMemberAnnotationProxy(annotation, fieldIntroConfig)) != null) {
            return proxy;
        }
        return null;
    }

    private Annotation getProxy(Class annotation, Method method) {
        Annotation proxy;
        MethodIntroConfig methodIntroConfig = this.getMethodIntroConfig(method);
        if (methodIntroConfig != null && (proxy = this.getMemberAnnotationProxy(annotation, methodIntroConfig)) != null) {
            return proxy;
        }
        return null;
    }

    private Annotation getProxy(Class annotation, Class clazz) {
        Annotation proxy;
        ClassIntroConfig classIntroConfig = this.getClassIntroConfig(clazz);
        if (classIntroConfig != null && (proxy = this.getClassAnnotationProxy(annotation, classIntroConfig)) != null) {
            return proxy;
        }
        return null;
    }
}

