/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jaxb.intros.ConfigurationException;
import org.jboss.jaxb.intros.configmodel.XmlTypeIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;

public class XmlTypeHandler
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(XmlTypeHandler.class);
    private XmlTypeIntro xmlTypeIntro;

    private XmlTypeHandler(XmlTypeIntro xmlTypeIntro) {
        this.xmlTypeIntro = xmlTypeIntro;
    }

    public static Annotation createProxy(XmlTypeIntro xmlTypeIntro) {
        return (Annotation)Proxy.newProxyInstance(XmlTypeIntro.class.getClassLoader(), new Class[]{XmlType.class, ClassValue.class}, (InvocationHandler)new XmlTypeHandler(xmlTypeIntro));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getClassValue")) {
            methodName = (String)args[1];
        }
        if (methodName.equals("namespace")) {
            return this.xmlTypeIntro.getNamespace();
        }
        if (methodName.equals("name")) {
            return this.xmlTypeIntro.getName();
        }
        if (methodName.equals("propOrder")) {
            try {
                String[] propOrder = this.xmlTypeIntro.getPropOrder().split(",");
                for (int i = 0; i < propOrder.length; ++i) {
                    String s = propOrder[i];
                    propOrder[i] = s.trim();
                }
                return propOrder;
            }
            catch (Exception e) {
                logger.warn((Object)("Bad 'XmlType.propOrder' config value '" + this.xmlTypeIntro.getPropOrder() + "' in JAXB Annotation Introduction config.  Must be a CSV String."));
            }
        } else {
            if (methodName.equals("factoryClass")) {
                if (this.xmlTypeIntro.getFactoryClass() != null) {
                    try {
                        return Class.forName(this.xmlTypeIntro.getFactoryClass());
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException("Bad 'XmlType.factoryClass' config value '" + this.xmlTypeIntro.getFactoryClass() + "' in JAXB Annotation Introduction config.  Class not found.");
                    }
                }
                return XmlType.DEFAULT.class;
            }
            if (methodName.equals("factoryMethod")) {
                return this.xmlTypeIntro.getFactoryMethod();
            }
        }
        return null;
    }
}

