/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.spi;

import java.io.Serializable;
import org.jboss.ha.framework.interfaces.ObjectStreamSource;
import org.jboss.ha.framework.server.MarshalledValueObjectStreamSource;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.spi.JBossSerializationObjectStreamSource;

public class SessionSerializationFactory {
    public static final String JBOSS_SERIALIZATION_SYS_PROP = "session.serialization.jboss";
    private static Logger log_ = Logger.getLogger(SessionSerializationFactory.class);
    private static boolean useJBossSerialization = false;
    private static ObjectStreamSource objectStreamSource;

    public static SimpleCachableMarshalledValue createMarshalledValue(Serializable o) {
        return new SimpleCachableMarshalledValue(o, objectStreamSource);
    }

    public static ObjectStreamSource getObjectStreamSource() {
        return objectStreamSource;
    }

    public static boolean useJBossSerialization() {
        return useJBossSerialization;
    }

    static {
        String useJBossSerializationStr = System.getProperty(JBOSS_SERIALIZATION_SYS_PROP, "false");
        useJBossSerialization = Boolean.valueOf(useJBossSerializationStr);
        objectStreamSource = useJBossSerialization ? new JBossSerializationObjectStreamSource() : new MarshalledValueObjectStreamSource();
        try {
            if (useJBossSerialization) {
                log_.debug((Object)"Using JBossSerialization for web session replication");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

