/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializableObjectHandler
extends AbstractHandler {
    private Cache<Object, Object> cache;
    private PojoCacheImpl pojoCache;
    private InternalHelper internal_;
    private final Log log_ = LogFactory.getLog(SerializableObjectHandler.class);

    public SerializableObjectHandler(PojoCacheImpl cache, InternalHelper internal) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.internal_ = internal;
    }

    @Override
    protected Fqn<?> getFqn(Object obj) {
        return null;
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    protected Object get(Fqn fqn, Class clazz, PojoInstance pojoInstance) throws CacheException {
        Object obj = this.internal_.get(fqn, "__SERIALIZED__");
        return obj;
    }

    @Override
    protected void put(Fqn<?> fqn, Reference reference, Object obj) throws CacheException {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("put(): obj (" + obj.getClass() + ") is non-advisable but serialize it anyway. " + "Note that if it is non-serializable we require to use JBoss Serialization."));
        }
        this.putIntoCache(fqn, obj);
    }

    private void putIntoCache(Fqn fqn, Object obj) throws CacheException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PojoInstance pojoInstance = new PojoInstance();
        pojoInstance.set(obj);
        pojoInstance.setPojoClass(obj.getClass());
        map.put("POJOCache.PojoInstance", pojoInstance);
        map.put("__SERIALIZED__", obj);
        this.internal_.put(fqn, map);
    }

    @Override
    protected Object remove(Fqn<?> fqn, Reference reference, Object result) throws CacheException {
        this.cache.removeNode(fqn);
        return result;
    }
}

