/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QNameDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(QNameDeserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, QNameDeserializer.sourceToString(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        QName value = null;
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        String valueStr = this.unwrapValueStr(xmlFragment, nsRegistry);
        if (valueStr != null) {
            value = SimpleTypeBindings.unmarshalQName((String)valueStr, (NamespaceContext)nsRegistry);
        }
        return value;
    }

    protected String unwrapValueStr(String xmlFragment, NamespaceRegistry nsRegistry) {
        if (!this.isEmptyElement(xmlFragment)) {
            try {
                Element el = DOMUtils.parse((String)xmlFragment);
                NamedNodeMap attribs = el.getAttributes();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Node attr = attribs.item(i);
                    String nodeName = attr.getNodeName();
                    if (!nodeName.startsWith("xmlns:")) continue;
                    String prefix = nodeName.substring(6);
                    String nsURI = attr.getNodeValue();
                    nsRegistry.registerURI(nsURI, prefix);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot parse xmlFragment: " + xmlFragment);
            }
        }
        return super.unwrapValueStr(xmlFragment);
    }
}

