/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.extensions.wsrm.RMFault;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceFault;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMSequenceFaultSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMSequenceFaultSerializer();

    private RMSequenceFaultSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        throw new NotImplementedException();
    }

    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMSequenceFault o = (RMSequenceFault)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            boolean isSoap11 = "http://schemas.xmlsoap.org/soap/envelope/".equals(soapEnvelope.getElementQName().getNamespaceURI());
            if (!isSoap11) {
                throw new NotImplementedException("TODO: implement SOAP 12 serialization");
            }
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName sequenceFaultQName = wsrmConstants.getSequenceFaultQName();
            SOAPElement sequenceFaultElement = soapEnvelope.getHeader().addChildElement(sequenceFaultQName);
            RMFault rmFault = (RMFault)((Object)o.getDetail());
            QName faultCodeQName = wsrmConstants.getFaultCodeQName();
            String subcode = wsrmConstants.getPrefix() + ":" + rmFault.getFaultCode().getSubcode().getValue();
            sequenceFaultElement.addChildElement(faultCodeQName).setValue(subcode);
            Map<String, Object> details = rmFault.getDetails();
            if (details.size() > 0) {
                Iterator<String> i = details.keySet().iterator();
                while (i.hasNext()) {
                    QName detailQName = wsrmConstants.getDetailQName();
                    SOAPElement detailElement = sequenceFaultElement.addChildElement(detailQName);
                    String key = i.next();
                    if ("identifier".equals(key)) {
                        String sequenceId = (String)details.get(key);
                        QName identifierQName = wsrmConstants.getIdentifierQName();
                        detailElement.addChildElement(identifierQName).setValue(sequenceId);
                        continue;
                    }
                    if ("acknowledgement".equals(key)) {
                        RMSequenceAcknowledgement.RMAcknowledgementRange ackRange = (RMSequenceAcknowledgement.RMAcknowledgementRange)details.get(key);
                        QName acknowledgementRangeQName = wsrmConstants.getAcknowledgementRangeQName();
                        QName upperQName = wsrmConstants.getUpperQName();
                        QName lowerQName = wsrmConstants.getLowerQName();
                        SOAPElement acknowledgementRangeElement = detailElement.addChildElement(acknowledgementRangeQName);
                        acknowledgementRangeElement.addAttribute(lowerQName, String.valueOf(ackRange.getLower()));
                        acknowledgementRangeElement.addAttribute(upperQName, String.valueOf(ackRange.getUpper()));
                        continue;
                    }
                    if ("maxMessageNumber".equals(key)) {
                        Long maxMessageNumber = (Long)details.get(key);
                        QName maxMessageNumberQName = wsrmConstants.getMaxMessageNumberQName();
                        detailElement.addChildElement(maxMessageNumberQName).setValue(maxMessageNumber.toString());
                        continue;
                    }
                    throw new IllegalArgumentException("Can't serialize detail with key " + key);
                }
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

