/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.ejb3.timerservice.TimedObjectInvokerBridge;
import org.jboss.as.ejb3.timerservice.TimerServiceFacade;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossTimerServiceFactory
implements TimerServiceFactory {
    private static Logger log = Logger.getLogger(JBossTimerServiceFactory.class);

    public TimerService createTimerService(TimedObjectInvoker invoker) {
        TimerServiceFacade timerService = null;
        try {
            EJBTimerService service = this.getEJBTimerService();
            ObjectName objectName = new ObjectName(invoker.getTimedObjectId());
            TimedObjectInvokerBridge bridge = new TimedObjectInvokerBridge(invoker);
            TimerService delegate = service.createTimerService(objectName, null, (org.jboss.ejb.txtimer.TimedObjectInvoker)bridge);
            timerService = new TimerServiceFacade(objectName, delegate);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Unable to initialize timer service", (Throwable)e);
            }
            log.trace((Object)"Unable to initialize timer service");
        }
        return timerService;
    }

    protected EJBTimerService getEJBTimerService() {
        return (EJBTimerService)MBeanProxyExt.create(EJBTimerService.class, (ObjectName)EJBTimerService.OBJECT_NAME, (MBeanServer)MBeanServerLocator.locateJBoss());
    }

    public void removeTimerService(TimerService timerService) {
        this.removeTimerService(((TimerServiceFacade)timerService).getContainerId());
    }

    protected void removeTimerService(ObjectName containerId) {
        try {
            EJBTimerService service = this.getEJBTimerService();
            service.removeTimerService(containerId, true);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Unable to initialize timer service", (Throwable)e);
            }
            log.trace((Object)"Unable to initialize timer service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTimerService(TimerService aTimerService) {
        if (aTimerService == null) {
            log.warn((Object)"TIMER SERVICE IS NOT INSTALLED");
            return;
        }
        TimerServiceFacade timerService = (TimerServiceFacade)aTimerService;
        ClassLoader loader = null;
        AllowedOperationsAssociation.pushInMethodFlag((int)AllowedOperationsAssociation.IN_BUSINESS_METHOD);
        try {
            this.getEJBTimerService().restoreTimers(timerService.getContainerId(), loader);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    public void suspendTimerService(TimerService timerService) {
        this.removeTimerService(timerService);
    }
}

