/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.ClientSocketWrapper;
import org.jboss.remoting.transport.socket.SocketClientInvoker;

public class MultiplexClientInvoker
extends SocketClientInvoker
implements BidirectionalClientInvoker {
    private static final Logger log = Logger.getLogger((Class)MultiplexClientInvoker.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    private InetAddress connectAddress;
    private String connectHost;
    private int connectPort;
    private InetSocketAddress connectSocketAddress;
    private InetSocketAddress bindSocketAddress;
    private String socketGroupId;
    private MultiplexServerInvoker.SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private boolean readyToRun;
    protected String clientSocketClassName = ClientSocketWrapper.class.getName();

    public MultiplexClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
    }

    public MultiplexClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
    }

    protected void handleConnect() throws ConnectionFailedException {
        try {
            Map parameters;
            log.debug((Object)("configuring MultiplexClientInvoker for: " + this.locator));
            super.handleConnect();
            this.connectAddress = InetAddress.getByName(this.locator.getHost());
            this.connectHost = this.connectAddress.getHostName();
            this.connectPort = this.locator.getPort();
            this.connectSocketAddress = new InetSocketAddress(this.connectAddress, this.connectPort);
            if (this.getSocketFactory() != null) {
                this.configuration.put("multiplex.SocketFactory", this.getSocketFactory());
            }
            if ((parameters = this.configuration) != null) {
                this.configureSocketGroupParameters(parameters);
            }
        }
        catch (Exception e) {
            throw new ConnectionFailedException(e.getMessage());
        }
    }

    public void finishStart() throws IOException {
        int bindPort;
        if (this.socketGroupInfo != null && this.socketGroupInfo.getBindAddress() != null && this.bindSocketAddress == null) {
            InetAddress bindAddress = this.socketGroupInfo.getBindAddress();
            bindPort = this.socketGroupInfo.getBindPort();
            this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
        }
        if (this.socketGroupInfo != null && this.socketGroupInfo.getBindAddress() != null && this.addressPair == null) {
            String bindHost = this.socketGroupInfo.getBindAddress().getHostName();
            bindPort = this.socketGroupInfo.getBindPort();
            this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
        }
        this.readyToRun = true;
    }

    public InvokerLocator getCallbackLocator(Map metadata) {
        VirtualSocket socket = this.socketGroupInfo.getPrimingSocket();
        metadata.put("multiplexConnectHost", ((Socket)socket).getInetAddress().getHostAddress());
        metadata.put("multiplexConnectPort", Integer.toString(((Socket)socket).getPort()));
        metadata.put("multiplexBindHost", ((Socket)socket).getInetAddress().getHostAddress());
        metadata.put("multiplexBindPort", Integer.toString(((Socket)socket).getPort()));
        InvokerLocator locator = new InvokerLocator("multiplex", ((Socket)socket).getLocalAddress().getHostAddress(), ((Socket)socket).getLocalPort(), null, metadata);
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSocketGroupParameters(Map parameters) throws IOException {
        int bindPort = -1;
        InetAddress bindAddress = null;
        this.socketGroupId = (String)parameters.get("clientMultiplexId");
        log.debug((Object)("socketGroupId: " + this.socketGroupId));
        Class clazz = MultiplexServerInvoker.SocketGroupInfo.class;
        synchronized (clazz) {
            if (this.socketGroupId != null) {
                this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId);
            }
            if (this.socketGroupInfo != null && this.socketGroupInfo.getServerInvoker() != null) {
                log.debug((Object)"client rule 1");
                InetAddress socketGroupConnectAddress = this.socketGroupInfo.getConnectAddress();
                int socketGroupConnectPort = this.socketGroupInfo.getConnectPort();
                if (socketGroupConnectAddress != null && !socketGroupConnectAddress.equals(this.connectAddress)) {
                    String message = "socket group connect address (" + socketGroupConnectAddress + ") does not match connect address (" + this.connectAddress + ")";
                    log.error((Object)message);
                    throw new IOException(message);
                }
                if (socketGroupConnectPort > 0 && socketGroupConnectPort != this.connectPort) {
                    String message = "socket group connect port (" + socketGroupConnectPort + ") does not match connect port (" + this.connectPort + ")";
                    log.error((Object)message);
                    throw new IOException(message);
                }
                bindAddress = this.socketGroupInfo.getBindAddress();
                bindPort = this.socketGroupInfo.getBindPort();
                this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
                if (this.socketGroupInfo.getPrimingSocket() == null) {
                    String connectHost = this.connectAddress.getHostName();
                    MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort, this.configuration, this.timeout);
                }
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.addClientInvoker(this);
                String bindHost = bindAddress.getHostName();
                this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
                MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
                MultiplexServerInvoker serverInvoker = this.socketGroupInfo.getServerInvoker();
                if (serverInvoker != null) {
                    serverInvoker.finishStart();
                }
                this.finishStart();
                return;
            }
            String bindHost = (String)parameters.get("multiplexBindHost");
            String bindPortString = (String)parameters.get("multiplexBindPort");
            if (bindHost != null && bindPortString == null) {
                bindPortString = "0";
            }
            if (bindHost == null && bindPortString != null) {
                bindHost = "localhost";
            }
            if (bindHost != null) {
                log.debug((Object)"client rule 2");
                try {
                    bindPort = Integer.parseInt(bindPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("number format error for bindPort: " + bindPortString);
                }
                if (bindPort != 0) {
                    this.bindSocketAddress = new InetSocketAddress(bindHost, bindPort);
                    this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
                    this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getAddressPairMap().get(this.addressPair);
                }
                if (this.socketGroupInfo != null) {
                    this.socketGroupInfo.setConnectAddress(this.connectAddress);
                    this.socketGroupInfo.setConnectPort(this.connectPort);
                    this.socketGroupInfo.addClientInvoker(this);
                    if (this.socketGroupId != null) {
                        String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
                        if (socketGroupSocketGroupId != null && !socketGroupSocketGroupId.equals(this.socketGroupId)) {
                            String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.socketGroupId + ")";
                            log.error((Object)message);
                            throw new IOException(message);
                        }
                        if (socketGroupSocketGroupId == null) {
                            this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                            MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                        }
                    }
                    this.finishStart();
                    return;
                }
                if (bindPort == 0 && this.socketGroupId == null) {
                    String message = "Can never be found by any MultiplexServerInvoker: bind port == 0 and socketGroupId == null";
                    log.warn((Object)message);
                }
                if (bindPort == 0) {
                    bindPort = PortUtil.findFreePort(bindHost);
                }
                this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.addClientInvoker(this);
                bindAddress = InetAddress.getByName(bindHost);
                this.socketGroupInfo.setBindAddress(bindAddress);
                this.socketGroupInfo.setBindPort(bindPort);
                String connectHost = this.connectAddress.getHostName();
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort, this.configuration, this.timeout);
                MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
                if (this.socketGroupId != null) {
                    this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                    MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                }
                this.finishStart();
                return;
            }
            if (this.socketGroupId != null) {
                log.debug((Object)"client rule 3");
                if (this.socketGroupInfo == null) {
                    this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                    this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                    this.socketGroupInfo.setConnectAddress(this.connectAddress);
                    this.socketGroupInfo.setConnectPort(this.connectPort);
                    MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                }
                this.socketGroupInfo.addClientInvoker(this);
                return;
            }
            log.debug((Object)"client rule 4");
            String connectHost = this.connectAddress.getHostName();
            this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
            MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, this.configuration, this.timeout);
            this.finishStart();
        }
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        log.debug((Object)"entering transport()");
        if (!this.readyToRun) {
            throw new IOException("connection to server has not been made");
        }
        return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDisconnect() {
        log.debug((Object)"entering handleDisconnect()");
        super.handleDisconnect();
        Class clazz = MultiplexServerInvoker.SocketGroupInfo.class;
        synchronized (clazz) {
            if (this.socketGroupInfo != null) {
                this.socketGroupInfo.removeClientInvoker(this);
                if (this.socketGroupInfo.getClientInvokers().isEmpty() && this.socketGroupInfo.getServerInvoker() == null) {
                    log.debug((Object)("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId()));
                    if (this.socketGroupInfo.getPrimingSocket() != null) {
                        log.debug((Object)"MultiplexClientInvoker: closing bind priming socket");
                        VirtualSocket ps = this.socketGroupInfo.getPrimingSocket();
                        if (ps != null) {
                            try {
                                ps.getManager().unregisterShareable();
                                ps.close();
                            }
                            catch (IOException e) {
                                log.error((Object)"Error closing bind priming socket during cleanup upon stopping", (Throwable)e);
                            }
                        }
                    }
                    this.socketGroupId = this.socketGroupInfo.getSocketGroupId();
                    if (this.socketGroupId != null) {
                        MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
                    }
                    if (this.addressPair != null) {
                        MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
                    }
                }
                this.socketGroupInfo = null;
            }
        }
    }

    protected InetSocketAddress getBindSocketAddress() {
        return this.bindSocketAddress;
    }

    protected InetSocketAddress getConnectSocketAddress() {
        return this.connectSocketAddress;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        VirtualSocket primingSocket;
        log.debug((Object)"MultiplexClientInvoker.createSocket()");
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        if (this.socketGroupInfo != null && this.socketGroupInfo.getPrimingSocket() != null && (!(primingSocket = this.socketGroupInfo.getPrimingSocket()).isFunctional() || primingSocket.hasReceivedDisconnectMessage())) {
            log.info((Object)"Current server is inaccessible.  Will try to connect to new server");
            primingSocket.close();
            if (this.bindSocketAddress != null) {
                InetAddress bindAddress = this.bindSocketAddress.getAddress();
                int bindPort = PortUtil.findFreePort(this.bindSocketAddress.getHostName());
                this.socketGroupInfo.setBindPort(bindPort);
                this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, this.connectHost, this.connectPort, bindAddress, bindPort, this.configuration, timeout);
            } else {
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, this.connectHost, this.connectPort, this.configuration, port);
            }
            MultiplexServerInvoker serverInvoker = this.socketGroupInfo.getServerInvoker();
            if (serverInvoker != null) {
                try {
                    serverInvoker.stop();
                    this.socketGroupInfo.setServerInvoker(null);
                    serverInvoker.resetLocator(this.bindSocketAddress.getPort());
                    serverInvoker.refreshServerSocket();
                    serverInvoker.setup();
                    serverInvoker.start();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            VirtualSocket socket = new VirtualSocket(this.configuration);
            for (int i = 0; i < 3; ++i) {
                try {
                    socket.connect(this.connectSocketAddress, this.bindSocketAddress, timeout);
                    return socket;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        VirtualSocket socket = new VirtualSocket(this.configuration);
        socket.connect(this.connectSocketAddress, this.bindSocketAddress, timeout);
        return socket;
    }
}

