/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.ui.component.UICache;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class CacheRendererBase
extends RendererBase {
    private static final LogProvider log = Logging.getLogProvider(UICache.class);
    private static Calendar lastLog = null;

    protected Class getComponentClass() {
        return UICache.class;
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UICache cache = (UICache)component;
        if (cache.isEnabled()) {
            String key = cache.getKey();
            String cachedContent = (String)cache.getCacheProvider().get(cache.getRegion(), key);
            if (cachedContent == null) {
                log.debug((Object)("rendering from scratch: " + key));
                StringWriter stringWriter = new StringWriter();
                ResponseWriter cachingResponseWriter = writer.cloneWithWriter((Writer)stringWriter);
                context.setResponseWriter(cachingResponseWriter);
                this.renderChildren(context, component);
                context.setResponseWriter(writer);
                String output = stringWriter.getBuffer().toString();
                writer.write(output);
                cache.getCacheProvider().put(cache.getRegion(), key, (Object)output);
            } else {
                log.debug((Object)("rendering from cache: " + key));
                writer.write(cachedContent);
            }
        } else {
            this.renderChildren(context, component);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

