/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JGroupsStackParser {
    public String parseClusterConfigXml(Element config) {
        StringBuilder buffer = new StringBuilder();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getLocalName();
            if (protocol == null) {
                protocol = tag.getNodeName();
            }
            buffer.append(protocol);
            this.processAttributes(buffer, tag);
            buffer.append(':');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private void processAttributes(StringBuilder buffer, Element tag) {
        NamedNodeMap attrs = tag.getAttributes();
        int attrLength = attrs.getLength();
        if (attrLength > 0) {
            buffer.append('(');
        }
        for (int a = 0; a < attrLength; ++a) {
            Attr attr = (Attr)attrs.item(a);
            this.processSingleAttribute(buffer, attr);
            if (a >= attrLength - 1) continue;
            buffer.append(';');
        }
        if (attrLength > 0) {
            buffer.append(')');
        }
    }

    private void processSingleAttribute(StringBuilder buffer, Attr attr) {
        String name = attr.getName();
        String value = attr.getValue();
        buffer.append(name);
        buffer.append('=');
        buffer.append(value);
    }
}

