/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.jboss.cache.Lifecycle;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;

public class SynchronizedRestarter {
    private AtomicBoolean restartInProgress = new AtomicBoolean(false);
    private ConcurrentHashSet<Thread> restartWaiters = new ConcurrentHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartComponent(Lifecycle component) throws Exception {
        if (this.restartInProgress.compareAndSet(false, true)) {
            try {
                component.stop();
                component.start();
            }
            finally {
                this.restartInProgress.set(false);
                for (Thread waiter : this.restartWaiters) {
                    try {
                        LockSupport.unpark(waiter);
                    }
                    catch (Throwable t) {}
                }
            }
        } else {
            this.restartWaiters.add(Thread.currentThread());
            if (this.restartInProgress.get()) {
                LockSupport.park();
            }
            this.restartWaiters.remove(Thread.currentThread());
        }
    }
}

