/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.Xid;
import org.jboss.resource.work.JBossWorkManagerMBean;
import org.jboss.resource.work.WorkWrapper;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.JBossXATerminator;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;

public class JBossWorkManager
extends ServiceMBeanSupport
implements WorkManager,
JBossWorkManagerMBean {
    private boolean trace;
    private ThreadPool threadPool;
    private JBossXATerminator xaTerminator;

    public JBossWorkManager() {
        this.trace = this.log.isTraceEnabled();
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public JBossXATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXATerminator(JBossXATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public WorkManager getInstance() {
        return this;
    }

    public void doWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 2, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 1, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
        return wrapper.getBlockedElapsed();
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 0, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    protected void importWork(WorkWrapper wrapper) throws WorkException {
        Xid xid;
        ExecutionContext ctx;
        this.trace = this.log.isTraceEnabled();
        if (this.trace) {
            this.log.trace((Object)("Importing work " + (Object)((Object)wrapper)));
        }
        if ((ctx = wrapper.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout() * 1000L;
            this.xaTerminator.registerWork(wrapper.getWork(), xid, timeout);
        }
        if (this.trace) {
            this.log.trace((Object)("Imported work " + (Object)((Object)wrapper)));
        }
    }

    protected void executeWork(WorkWrapper wrapper) throws WorkException {
        if (this.trace) {
            this.log.trace((Object)("Submitting work to thread pool " + (Object)((Object)wrapper)));
        }
        this.threadPool.runTaskWrapper((TaskWrapper)wrapper);
        if (this.trace) {
            this.log.trace((Object)("Submitted work to thread pool " + (Object)((Object)wrapper)));
        }
    }

    protected void startWork(WorkWrapper wrapper) throws WorkException {
        Xid xid;
        ExecutionContext ctx;
        if (this.trace) {
            this.log.trace((Object)("Starting work " + (Object)((Object)wrapper)));
        }
        if ((ctx = wrapper.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.startWork(wrapper.getWork(), xid);
        }
        if (this.trace) {
            this.log.trace((Object)("Started work " + (Object)((Object)wrapper)));
        }
    }

    protected void endWork(WorkWrapper wrapper) {
        Xid xid;
        ExecutionContext ctx;
        if (this.trace) {
            this.log.trace((Object)("Ending work " + (Object)((Object)wrapper)));
        }
        if ((ctx = wrapper.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.endWork(wrapper.getWork(), xid);
        }
        if (this.trace) {
            this.log.trace((Object)("Ended work " + (Object)((Object)wrapper)));
        }
    }

    protected void cancelWork(WorkWrapper wrapper) {
        Xid xid;
        ExecutionContext ctx;
        if (this.trace) {
            this.log.trace((Object)("Cancel work " + (Object)((Object)wrapper)));
        }
        if ((ctx = wrapper.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.cancelWork(wrapper.getWork(), xid);
        }
        if (this.trace) {
            this.log.trace((Object)("Canceled work " + (Object)((Object)wrapper)));
        }
    }
}

