/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool<T> {
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();

    public final T take() {
        T t = this.queue.poll();
        if (t == null) {
            return this.create();
        }
        return t;
    }

    public final void recycle(T t) {
        this.queue.offer(t);
    }

    protected abstract T create();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TubePool
    extends Pool<Tube> {
        private final Tube master;

        public TubePool(Tube master) {
            this.master = master;
            this.recycle(master);
        }

        @Override
        protected Tube create() {
            return TubeCloner.clone(this.master);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Unmarshaller
    extends Pool<javax.xml.bind.Unmarshaller> {
        private final JAXBContext context;

        public Unmarshaller(JAXBContext context) {
            this.context = context;
        }

        @Override
        protected javax.xml.bind.Unmarshaller create() {
            try {
                return this.context.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Marshaller
    extends Pool<javax.xml.bind.Marshaller> {
        private final JAXBContext context;

        public Marshaller(JAXBContext context) {
            this.context = context;
        }

        @Override
        protected javax.xml.bind.Marshaller create() {
            try {
                return this.context.createMarshaller();
            }
            catch (JAXBException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

