/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        SystemInfo sysInfo = discoveryContext.getSystemInformation();
        if (!sysInfo.isNative()) {
            this.log.debug((Object)("Skipping " + discoveryContext.getResourceType().getName() + " discovery, since native system info is not available."));
            return results;
        }
        String hostname = discoveryContext.getSystemInformation().getHostname();
        for (FileSystemInfo fs : sysInfo.getFileSystems()) {
            int fsType = fs.getFileSystem().getType();
            if (fsType != 2 && fsType != 3) continue;
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            try {
                String name = (hostname == null ? "" : hostname + " ") + " File System (" + fs.getFileSystem().getTypeName() + ") " + fs.getMountPoint();
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), fs.getMountPoint(), name, null, fs.getFileSystem().getDevName() + ": " + fs.getFileSystem().getDirName(), pluginConfig, null);
                results.add(details);
            }
            catch (Exception e) {
                this.log.error((Object)("File system discovery failed: " + e + ", skipping."));
            }
        }
        return results;
    }
}

