/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.cloud.FailoverList;
import org.rhq.core.domain.cloud.Server;

@Entity(name="FailoverListDetails")
@NamedQueries(value={@NamedQuery(name="FailoverListDetails.getViaAgentId", query="SELECT fld FROM FailoverListDetails fld WHERE fld.failoverList IN ( SELECT fl FROM FailoverList fl WHERE fl.agent.id = :agentId )"), @NamedQuery(name="FailoverListDetails.getViaAgentIdWithServers", query="SELECT fld FROM FailoverListDetails fld JOIN FETCH fld.server WHERE fld.failoverList IN ( SELECT fl FROM FailoverList fl WHERE fl.agent.id = :agentId )"), @NamedQuery(name="FailoverListDetails.deleteViaAgent", query="DELETE FROM FailoverListDetails fld WHERE fld.failoverList IN ( SELECT fl FROM FailoverList fl WHERE fl.agent = :agent )"), @NamedQuery(name="FailoverListDetails.deleteViaServer", query="DELETE FROM FailoverListDetails fld WHERE fld.server.id = :serverId"), @NamedQuery(name="FailoverListDetails.getAssignedLoads", query="SELECT new org.rhq.core.domain.cloud.composite.FailoverListDetailsComposite(fld.ordinal, fld.serverId, COUNT(fld.serverId)) FROM FailoverListDetails fld GROUP BY fld.ordinal, fld.serverId ORDER BY fld.ordinal ASC"), @NamedQuery(name="FailoverListDetails.truncate", query="DELETE FROM FailoverListDetails")})
@SequenceGenerator(name="id", sequenceName="RHQ_FAILOVER_DETAILS_ID_SEQ")
@Table(name="RHQ_FAILOVER_DETAILS")
public class FailoverListDetails
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_GET_VIA_AGENT_ID = "FailoverListDetails.getViaAgentId";
    public static final String QUERY_GET_VIA_AGENT_ID_WITH_SERVERS = "FailoverListDetails.getViaAgentIdWithServers";
    public static final String QUERY_DELETE_VIA_AGENT = "FailoverListDetails.deleteViaAgent";
    public static final String QUERY_DELETE_VIA_SERVER = "FailoverListDetails.deleteViaServer";
    public static final String QUERY_GET_ASSIGNED_LOADS = "FailoverListDetails.getAssignedLoads";
    public static final String QUERY_TRUNCATE = "FailoverListDetails.truncate";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="id")
    @Id
    private int id;
    @JoinColumn(name="FAILOVER_LIST_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    protected FailoverList failoverList;
    @Column(name="ORDINAL", nullable=false)
    private int ordinal;
    @JoinColumn(name="SERVER_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    protected Server server;
    @Column(name="SERVER_ID", insertable=false, updatable=false)
    private int serverId;

    protected FailoverListDetails() {
    }

    public FailoverListDetails(FailoverList failoverList, int ordinal, Server server) {
        this.failoverList = failoverList;
        this.ordinal = ordinal;
        this.server = server;
        this.serverId = server.getId();
    }

    public FailoverList getFailoverList() {
        return this.failoverList;
    }

    public void setFailoverList(FailoverList failoverList) {
        this.failoverList = failoverList;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server agent) {
        this.server = agent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.serverId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FailoverListDetails)) {
            return false;
        }
        FailoverListDetails other = (FailoverListDetails)obj;
        if (this.failoverList == null ? other.failoverList != null : !this.failoverList.equals(other.failoverList)) {
            return false;
        }
        return this.ordinal == other.ordinal;
    }
}

