/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;

@Entity
@Table(name="RHQ_RESOURCE_AVAIL")
@NamedQueries(value={@NamedQuery(name="ResourceAvailability.findByResourceId", query="  SELECT ra FROM ResourceAvailability ra WHERE ra.resourceId = :resourceId "), @NamedQuery(name="ResourceAvailability.updateByAgentId", query="  UPDATE ResourceAvailability      SET availabilityType = :availabilityType    WHERE resourceId IN ( SELECT res.id                            FROM Resource res                           WHERE res.agent.id = :agentId ) "), @NamedQuery(name="ResourceAvailability.insertByResourceIds", query="  INSERT INTO ResourceAvailability ( resourceId )        SELECT res.id          FROM Resource res     LEFT JOIN res.currentAvailability avail         WHERE res.id IN ( :resourceIds )           AND avail IS NULL ")})
@SequenceGenerator(name="RHQ_RESOURCE_AVAIL_SEQ", sequenceName="RHQ_RESOURCE_AVAIL_ID_SEQ", allocationSize=100)
public class ResourceAvailability
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_RESOURCE_AVAIL";
    public static final String QUERY_FIND_BY_RESOURCE_ID = "ResourceAvailability.findByResourceId";
    public static final String UPDATE_BY_AGENT_ID = "ResourceAvailability.updateByAgentId";
    public static final String INSERT_BY_RESOURCE_IDS = "ResourceAvailability.insertByResourceIds";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_RESOURCE_AVAIL_SEQ")
    @Id
    private int id;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @OneToOne(fetch=FetchType.LAZY)
    private Resource resource;
    @Column(name="RESOURCE_ID", insertable=false, updatable=false)
    private int resourceId;
    @Column(name="AVAILABILITY_TYPE", nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private AvailabilityType availabilityType;

    protected ResourceAvailability() {
    }

    public ResourceAvailability(Resource resource, AvailabilityType type) {
        if (resource == null) {
            throw new IllegalArgumentException("resource==null");
        }
        this.resource = resource;
        this.resourceId = resource.getId();
        this.availabilityType = type;
    }

    public Resource getResource() {
        return this.resource;
    }

    public AvailabilityType getAvailabilityType() {
        return this.availabilityType;
    }

    public void setAvailabilityType(AvailabilityType availabilityType) {
        this.availabilityType = availabilityType;
    }

    public String toString() {
        return "Availability[resourceId=" + this.resourceId + ", avail=" + (Object)((Object)this.availabilityType) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availabilityType == null ? 0 : this.availabilityType.hashCode());
        result = 31 * result + this.resourceId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceAvailability)) {
            return false;
        }
        ResourceAvailability other = (ResourceAvailability)obj;
        if (this.resourceId != other.resourceId) {
            return false;
        }
        return !(this.availabilityType == null ? other.availabilityType != null : !this.availabilityType.equals((Object)other.availabilityType));
    }
}

