/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceErrorType;

@Entity
@NamedQueries(value={@NamedQuery(name="ResourceError.deleteByResources", query="DELETE From ResourceError re WHERE re.resource IN (:resources)"), @NamedQuery(name="ResourceError.findByResource", query="SELECT re FROM ResourceError re WHERE re.resource.id = :resourceId"), @NamedQuery(name="ResourceError.findByResourceAndErrorType", query="SELECT re FROM ResourceError re WHERE re.resource.id = :resourceId AND re.errorType = :errorType")})
@SequenceGenerator(name="RHQ_RESOURCE_ERROR_SEQ", sequenceName="RHQ_RESOURCE_ERROR_ID_SEQ")
@Table(name="RHQ_RESOURCE_ERROR")
public class ResourceError
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCES = "ResourceError.deleteByResources";
    public static final String QUERY_FIND_BY_RESOURCE_ID = "ResourceError.findByResource";
    public static final String QUERY_FIND_BY_RESOURCE_ID_AND_ERROR_TYPE = "ResourceError.findByResourceAndErrorType";
    private static final int MAX_SUMMARY_LENGTH = 1000;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_RESOURCE_ERROR_SEQ")
    @Id
    private int id;
    @Column(name="TIME_OCCURRED", nullable=false)
    private long timeOccurred;
    @JoinColumn(name="RESOURCE_ID", nullable=false)
    @ManyToOne
    private Resource resource;
    @Column(name="ERROR_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ResourceErrorType errorType;
    @Column(name="SUMMARY", nullable=false, length=1000)
    private String summary;
    @Column(name="DETAIL", nullable=true)
    private String detail;

    protected ResourceError() {
    }

    public ResourceError(@NotNull Resource resource, @NotNull ResourceErrorType errorType, @NotNull String summary, @Nullable String detail, long timeOccurred) {
        this.setResource(resource);
        this.setErrorType(errorType);
        this.setSummary(summary);
        this.setDetail(detail);
        this.setTimeOccurred(timeOccurred);
    }

    public ResourceError(@NotNull Resource resource, @NotNull ResourceErrorType errorType, @NotNull Throwable exception, long timeOccurred) {
        this.setResource(resource);
        this.setErrorType(errorType);
        this.setSummary(exception.getLocalizedMessage());
        this.setDetailFromThrowable(exception);
        this.setTimeOccurred(timeOccurred);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ResourceErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ResourceErrorType errorType) {
        this.errorType = errorType;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        if (summary != null && summary.length() > 1000) {
            summary = summary.substring(0, 997) + "...";
        }
        this.summary = summary;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setDetailFromThrowable(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        this.setDetail(stackTrace);
    }

    public long getTimeOccurred() {
        return this.timeOccurred;
    }

    public void setTimeOccurred(long timeOccurred) {
        this.timeOccurred = timeOccurred;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ResourceError: ");
        str.append("id=[").append(this.id);
        str.append("], time-occurred=[").append(new Date(this.timeOccurred));
        str.append("], error-type=[").append((Object)this.errorType);
        str.append("], resource=[").append(this.resource);
        str.append("], summary=[").append(this.summary);
        str.append("], detail=[").append(this.detail);
        str.append("]");
        return str.toString();
    }
}

