/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.group;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="GroupDefinition.findAll", query="SELECT gd   FROM GroupDefinition AS gd "), @NamedQuery(name="GroupDefinition.findByName", query="SELECT gd   FROM GroupDefinition AS gd  WHERE LOWER(gd.name) = LOWER(:name)"), @NamedQuery(name="GroupDefinition.findMembers_count", query="SELECT COUNT(rg)   FROM ResourceGroup rg  WHERE rg.groupDefinition.id = :groupDefinitionId "), @NamedQuery(name="GroupDefinition.findAllMembers_admin", query="SELECT rg   FROM ResourceGroup rg  WHERE rg.groupDefinition IS NOT NULL "), @NamedQuery(name="GroupDefinition.findManagedResourceGroupIds_admin", query="SELECT rg.id   FROM ResourceGroup rg  WHERE rg.groupDefinition.id = :groupDefinitionId "), @NamedQuery(name="GroupDefinition.findIdsForRecalculation_admin", query=" SELECT gd.id    FROM GroupDefinition gd   WHERE gd.recalculationInterval != 0     AND ( ( gd.lastCalculationTime IS NOT NULL             AND ( gd.lastCalculationTime + gd.recalculationInterval < :now ) )           OR           ( gd.lastCalculationTime IS NULL             AND ( gd.modifiedTime + gd.recalculationInterval < :now ) ) ) "), @NamedQuery(name="GroupDefinition.findAllRecalculating_admin", query="SELECT gd   FROM GroupDefinition AS gd  WHERE gd.recalculationInterval != 0 ")})
@SequenceGenerator(name="id", sequenceName="RHQ_GROUP_DEF_ID_SEQ")
@Table(name="RHQ_GROUP_DEF")
public class GroupDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "GroupDefinition.findAll";
    public static final String QUERY_FIND_BY_NAME = "GroupDefinition.findByName";
    public static final String QUERY_FIND_MEMBERS = "GroupDefinition.findMembers";
    public static final String QUERY_FIND_MEMBERS_count = "GroupDefinition.findMembers_count";
    public static final String QUERY_FIND_ALL_MEMBERS = "GroupDefinition.findAllMembers_admin";
    public static final String QUERY_FIND_MANAGED_RESOURCE_GROUP_IDS_ADMIN = "GroupDefinition.findManagedResourceGroupIds_admin";
    public static final String QUERY_FIND_IDS_FOR_RECALCULATION = "GroupDefinition.findIdsForRecalculation_admin";
    public static final String QUERY_FIND_ALL_RECALCULATING = "GroupDefinition.findAllRecalculating_admin";
    public static final String QUERY_NATIVE_FIND_MEMBERS = "         SELECT               (     SELECT COUNT(eresAvail.ID)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id               ) as explicitCount,               (     SELECT AVG(eresAvail.availability_type)                       FROM rhq_resource_avail eresAvail                 INNER JOIN rhq_resource eres                         ON eresAvail.resource_id = eres.id                 INNER JOIN rhq_resource_group_res_exp_map expMap                         ON eres.id = expMap.resource_id                      WHERE expMap.resource_group_id = rg.id               ) as explicitAvail,               (     SELECT COUNT(iresAvail.ID)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id               ) as implicitCount,               (     SELECT AVG(iresAvail.availability_type)                       FROM rhq_resource_avail iresAvail                 INNER JOIN rhq_resource ires                         ON iresAvail.resource_id = ires.id                 INNER JOIN rhq_resource_group_res_imp_map impMap                         ON ires.id = impMap.resource_id                      WHERE impMap.resource_group_id = rg.id               ) as implicitAvail,                 rg.id as groupId            FROM rhq_resource_group rg LEFT OUTER JOIN rhq_resource_group_res_imp_map memberMap              ON rg.id = memberMap.resource_group_id LEFT OUTER JOIN rhq_resource res              ON memberMap.resource_id = res.id LEFT OUTER JOIN rhq_resource_avail resAvail              ON res.id = resAvail.resource_id           WHERE rg.group_definition_id = ?        GROUP BY rg.id, rg.category, rg.name, rg.group_by ";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="id")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="RECURSIVE")
    private boolean recursive;
    @Column(name="CTIME")
    private Long createdTime;
    @Column(name="MTIME")
    private Long modifiedTime;
    @Column(name="CALC_TIME")
    private Long lastCalculationTime;
    @Column(name="CALC_INTERVAL")
    private long recalculationInterval;
    @Column(name="EXPRESSION")
    private String expression;
    @OneToMany(mappedBy="groupDefinition", cascade={CascadeType.PERSIST})
    private Set<ResourceGroup> managedResourceGroups;

    protected GroupDefinition() {
    }

    public GroupDefinition(String name) {
        this.name = name;
    }

    public String toString() {
        return "GroupDefinition[id=" + this.getId() + ", " + "name=" + this.getName() + "]";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long ctime) {
        this.createdTime = ctime;
    }

    public Long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Long mtime) {
        this.modifiedTime = mtime;
    }

    @PrePersist
    void onPersist() {
        this.modifiedTime = this.createdTime = Long.valueOf(System.currentTimeMillis());
    }

    @PreUpdate
    void onUpdate() {
        this.modifiedTime = System.currentTimeMillis();
    }

    public Long getLastCalculationTime() {
        return this.lastCalculationTime;
    }

    public void setLastCalculationTime(Long lastCalculationTime) {
        this.lastCalculationTime = lastCalculationTime;
    }

    public Long getRecalculationInterval() {
        return this.recalculationInterval;
    }

    public void setRecalculationInterval(Long recalculationInterval) {
        this.recalculationInterval = recalculationInterval;
    }

    public Long getNextCalculationTime() {
        if (this.getRecalculationInterval() == 0L) {
            return 0L;
        }
        if (this.getLastCalculationTime() != null) {
            return this.getLastCalculationTime() + this.getRecalculationInterval();
        }
        return this.getModifiedTime() + this.getRecalculationInterval();
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> getExpressionAsList() {
        return StringUtils.getStringAsList(this.expression, "\n", false);
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Set<ResourceGroup> getManagedResourceGroups() {
        return this.managedResourceGroups;
    }

    public void addResourceGroup(ResourceGroup resourceGroup) {
        if (this.managedResourceGroups == null) {
            this.managedResourceGroups = new HashSet<ResourceGroup>();
        }
        this.managedResourceGroups.add(resourceGroup);
        resourceGroup.setGroupDefinition(this);
    }

    public void removeResourceGroup(ResourceGroup resourceGroup) {
        if (this.managedResourceGroups == null) {
            return;
        }
        this.managedResourceGroups.remove(resourceGroup);
        resourceGroup.setGroupDefinition(null);
    }

    public void setManagedResourceGroups(Set<ResourceGroup> managedResourceGroups) {
        this.managedResourceGroups = managedResourceGroups;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GroupDefinition)) {
            return false;
        }
        GroupDefinition other = (GroupDefinition)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

