/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.WarMeasurementFacetDelegate;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedDeploymentComponent
extends AbstractManagedComponent
implements MeasurementFacet,
OperationFacet,
ProgressListener {
    public static final String DEPLOYMENT_NAME_PROPERTY = "deploymentName";
    public static final String DEPLOYMENT_TYPE_NAME_PROPERTY = "deploymentTypeName";
    public static final String EXTENSION_PROPERTY = "extension";
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private final Log log = LogFactory.getLog(this.getClass());
    protected String deploymentName;
    protected KnownDeploymentTypes deploymentType;
    protected File deploymentFile;

    @Override
    public void start(ResourceContext<ProfileServiceComponent> resourceContext) throws Exception {
        super.start(resourceContext);
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        this.deploymentName = pluginConfig.getSimple(DEPLOYMENT_NAME_PROPERTY).getStringValue();
        this.deploymentFile = this.getDeploymentFile();
        String deploymentTypeName = pluginConfig.getSimple(DEPLOYMENT_TYPE_NAME_PROPERTY).getStringValue();
        this.deploymentType = KnownDeploymentTypes.valueOf((String)deploymentTypeName);
        this.log.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.deploymentType + " deployment '" + this.deploymentName + "' with path '" + this.deploymentFile + "'."));
    }

    public AvailabilityType getAvailability() {
        try {
            return this.getManagedDeployment().getDeploymentState() == DeploymentState.STARTED ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (NoSuchDeploymentException e) {
            this.log.warn((Object)(this.deploymentType + " deployment '" + this.deploymentName + "' not found. Cause: " + e.getLocalizedMessage()));
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        if (this.deploymentType == KnownDeploymentTypes.JavaEEWebApplication) {
            WarMeasurementFacetDelegate warMeasurementFacetDelegate = new WarMeasurementFacetDelegate(this);
            warMeasurementFacetDelegate.getValues(report, requests);
        }
    }

    private static boolean isRequestInReport(MeasurementReport report, MeasurementScheduleRequest request) {
        if (request.getDataType() == DataType.MEASUREMENT) {
            for (MeasurementDataNumeric numericDatum : report.getNumericData()) {
                if (!numericDatum.getName().equals(request.getName())) continue;
                return true;
            }
            for (MeasurementDataTrait traitDatum : report.getTraitData()) {
                if (!traitDatum.getName().equals(request.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        DeploymentProgress progress;
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        if (name.equals("start")) {
            progress = deploymentManager.start(new String[]{this.deploymentName});
        } else if (name.equals("stop")) {
            progress = deploymentManager.stop(new String[]{this.deploymentName});
        } else if (name.equals("restart")) {
            progress = deploymentManager.stop(new String[]{this.deploymentName});
            DeploymentStatus stopStatus = DeploymentUtils.run(progress);
            progress = deploymentManager.start(new String[]{this.deploymentName});
        } else {
            throw new UnsupportedOperationException(name);
        }
        DeploymentStatus status = DeploymentUtils.run(progress);
        this.log.debug((Object)("Operation '" + name + "' on " + this.getResourceDescription() + " returned status [" + status + "]."));
        if (status.isFailed()) {
            throw status.getFailure();
        }
        return new OperationResult();
    }

    public void progressEvent(ProgressEvent event) {
        this.log.debug((Object)event);
    }

    @Override
    protected Map<String, ManagedProperty> getManagedProperties() throws Exception {
        return this.getManagedDeployment().getProperties();
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    protected void updateComponent() throws Exception {
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.process();
    }

    protected ManagedDeployment getManagedDeployment() throws NoSuchDeploymentException {
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.load();
        return managementView.getDeployment(this.deploymentName);
    }

    private File getDeploymentFile() throws MalformedURLException {
        URL vfsURL = new URL(this.deploymentName);
        String path = vfsURL.getPath();
        if (IS_WINDOWS && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return new File(path);
    }
}

