/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.types.MetaType;
import org.rhq.plugins.jbossas5.adapter.api.MeasurementAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.measurement.SimpleMetaValueMeasurementAdapter;

public class MeasurementAdapterFactory {
    private static final Log LOG = LogFactory.getLog(MeasurementAdapterFactory.class);
    private static Map<String, String> customAdapters = new HashMap<String, String>();

    public MeasurementAdapterFactory() {
        customAdapters.put("NoClasses", "NoClasses");
    }

    public static MeasurementAdapter getMeasurementPropertyAdapter(MetaType metaType) {
        SimpleMetaValueMeasurementAdapter measurementAdapter = null;
        if (metaType.isSimple()) {
            measurementAdapter = new SimpleMetaValueMeasurementAdapter();
        } else if (metaType.isGeneric()) {
            measurementAdapter = null;
        } else if (metaType.isComposite()) {
            measurementAdapter = null;
        } else if (metaType.isTable()) {
            measurementAdapter = null;
        } else if (metaType.isCollection()) {
            measurementAdapter = null;
        } else if (metaType.isArray()) {
            measurementAdapter = null;
        }
        return measurementAdapter;
    }

    public static MeasurementAdapter getCustomMeasurementPropertyAdapter(String measurementName) {
        MeasurementAdapter measurementAdapter = null;
        String adapterClassName = customAdapters.get(measurementName);
        if (adapterClassName != null && !adapterClassName.equals("")) {
            try {
                measurementAdapter = (MeasurementAdapter)Class.forName(adapterClassName).newInstance();
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Cannot instantiate adapter class called " + adapterClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Cannot access adapter class called " + adapterClassName), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Cannot find adapter class called " + adapterClassName), (Throwable)e);
            }
        }
        return measurementAdapter;
    }
}

