/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.event;

import java.util.HashSet;
import org.hyperic.sigar.Sigar;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.event.EventManager;
import org.rhq.core.pc.event.EventUtility;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;

public class EventContextImpl
implements EventContext {
    private Resource resource;
    private EventManager eventManager;

    public EventContextImpl(@NotNull Resource resource) {
        this.resource = resource;
        this.eventManager = PluginContainer.getInstance().getEventManager();
    }

    public void publishEvent(@NotNull Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event parameter must not be null.");
        }
        EventDefinition eventDefinition = EventUtility.getEventDefinition(event.getType(), this.resource.getResourceType());
        if (eventDefinition == null) {
            throw new IllegalArgumentException("Event has unknown event type - no EventDefinition exists with name '" + event.getType() + "'.");
        }
        HashSet<Event> events = new HashSet<Event>();
        events.add(event);
        this.eventManager.publishEvents(events, this.resource);
    }

    public void registerEventPoller(@NotNull EventPoller poller, int pollingInterval) {
        if (poller == null) {
            throw new IllegalArgumentException("poller parameter must not be null.");
        }
        String sourceLocation = null;
        this.registerEventPollerInternal(poller, pollingInterval, sourceLocation);
    }

    public void registerEventPoller(@NotNull EventPoller poller, int pollingInterval, @NotNull String sourceLocation) {
        if (poller == null) {
            throw new IllegalArgumentException("poller parameter must not be null.");
        }
        if (sourceLocation == null) {
            throw new IllegalArgumentException("sourceLocation parameter must not be null.");
        }
        this.registerEventPollerInternal(poller, pollingInterval, sourceLocation);
    }

    public void unregisterEventPoller(@NotNull String eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("eventType parameter must not be null.");
        }
        String sourceLocation = null;
        this.unregisterEventPollerInternal(eventType, sourceLocation);
    }

    public void unregisterEventPoller(@NotNull String eventType, @NotNull String sourceLocation) {
        if (eventType == null) {
            throw new IllegalArgumentException("eventType parameter must not be null.");
        }
        if (sourceLocation == null) {
            throw new IllegalArgumentException("sourceLocation parameter must not be null.");
        }
        this.unregisterEventPollerInternal(eventType, sourceLocation);
    }

    @NotNull
    public Sigar getSigar() {
        return this.eventManager.getSigar();
    }

    private void registerEventPollerInternal(EventPoller poller, int pollingInterval, String sourceLocation) {
        EventDefinition eventDefinition = EventUtility.getEventDefinition(poller.getEventType(), this.resource.getResourceType());
        if (eventDefinition == null) {
            throw new IllegalArgumentException("Poller has unknown event type - no EventDefinition exists with name '" + poller.getEventType() + "'.");
        }
        int adjustedPollingInterval = Math.max(60, pollingInterval);
        this.eventManager.registerEventPoller(poller, adjustedPollingInterval, this.resource, sourceLocation);
    }

    private void unregisterEventPollerInternal(String eventType, String sourceLocation) {
        EventDefinition eventDefinition = EventUtility.getEventDefinition(eventType, this.resource.getResourceType());
        if (eventDefinition == null) {
            throw new IllegalArgumentException("Unknown event type - no EventDefinition exists with name '" + eventType + "'.");
        }
        this.eventManager.unregisterEventPoller(this.resource, eventType, sourceLocation);
    }
}

