/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
StateHolder {
    private static final String FAILED_VALIDATION = "Invalid value - does not match regular expression: ";
    private String regex;
    private boolean isTransient;

    public RegexValidator() {
    }

    public RegexValidator(String regex) {
        this.regex = regex;
    }

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        String stringValue;
        if (value != null && !(stringValue = value.toString()).matches(this.regex)) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, FAILED_VALIDATION + this.regex, null));
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] values = (Object[])object;
        this.regex = (String)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.regex};
        return values;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }
}

