/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition.constraint;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;

@DiscriminatorValue(value="INTEGER_RANGE")
@Entity
public class IntegerRangeConstraint
extends Constraint {
    private static final String UNBOUNDED_SYMBOL = "*";
    private static final long serialVersionUID = 1L;
    @Transient
    private Long minimum;
    @Transient
    private Long maximum;

    public IntegerRangeConstraint(Long minimum, Long maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.rebuildDetails();
    }

    protected IntegerRangeConstraint() {
    }

    public void setDetails(String details) {
        super.setDetails(details);
        if (details != null) {
            this.splitAndPopulate();
        }
    }

    public void setMinimum(Long minimum) {
        this.minimum = minimum;
        this.rebuildDetails();
    }

    public Long getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Long maximum) {
        this.maximum = maximum;
        this.rebuildDetails();
    }

    public Long getMaximum() {
        return this.maximum;
    }

    @PostLoad
    private void splitAndPopulate() {
        String[] split = this.details.split("#");
        assert (split != null && split.length == 2) : "IntegerRangeConstraint.setDetails - Details could not be split. Details: " + this.details;
        this.minimum = UNBOUNDED_SYMBOL.equals(split[0]) ? null : new Long(split[0]);
        this.maximum = UNBOUNDED_SYMBOL.equals(split[1]) ? null : new Long(split[1]);
    }

    private void rebuildDetails() {
        String min = this.minimum == null ? UNBOUNDED_SYMBOL : this.minimum.toString();
        String max = this.maximum == null ? UNBOUNDED_SYMBOL : this.maximum.toString();
        super.setDetails(min + "#" + max);
    }
}

