/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelContentSourcePK;
import org.rhq.core.domain.content.ContentSource;

@Entity
@IdClass(value=ChannelContentSourcePK.class)
@NamedQueries(value={@NamedQuery(name="ChannelContentSource.deleteByContentSourceId", query="DELETE ChannelContentSource ccs WHERE ccs.contentSource.id = :contentSourceId"), @NamedQuery(name="ChannelContentSource.deleteByChannelId", query="DELETE ChannelContentSource ccs WHERE ccs.channel.id = :channelId")})
@Table(name="RHQ_CHANNEL_CONTENT_SRC_MAP")
public class ChannelContentSource
implements Serializable {
    public static final String DELETE_BY_CONTENT_SOURCE_ID = "ChannelContentSource.deleteByContentSourceId";
    public static final String DELETE_BY_CHANNEL_ID = "ChannelContentSource.deleteByChannelId";
    private static final long serialVersionUID = 1L;
    @Id
    private Channel channel;
    @Id
    private ContentSource contentSource;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected ChannelContentSource() {
    }

    public ChannelContentSource(Channel channel, ContentSource contentSource) {
        this.channel = channel;
        this.contentSource = contentSource;
    }

    public ChannelContentSourcePK getChannelContentSourcePK() {
        return new ChannelContentSourcePK(this.channel, this.contentSource);
    }

    public void setChannelContentSourcePK(ChannelContentSourcePK pk) {
        this.channel = pk.getChannel();
        this.contentSource = pk.getContentSource();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ChannelContentSource: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", ch=[").append(this.channel).append("]");
        str.append(", cs=[").append(this.contentSource).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        result = 31 * result + (this.contentSource == null ? 0 : this.contentSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ChannelContentSource)) {
            return false;
        }
        ChannelContentSource other = (ChannelContentSource)obj;
        if (this.channel == null ? this.channel != null : !this.channel.equals(other.channel)) {
            return false;
        }
        return !(this.contentSource == null ? this.contentSource != null : !this.contentSource.equals(other.contentSource));
    }
}

