/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.ContentRequestType;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="ContentServiceRequest.findWithStatus", query="SELECT csr FROM ContentServiceRequest AS csr WHERE csr.status = :status"), @NamedQuery(name="ContentServiceRequest.findByResourceWithStatus", query="SELECT csr FROM ContentServiceRequest AS csr WHERE csr.resource.id = :resourceId AND csr.status = :status"), @NamedQuery(name="ContentServiceRequest.findByResourceWithNotStatus", query="SELECT csr FROM ContentServiceRequest AS csr WHERE csr.resource.id = :resourceId AND csr.status <> :status"), @NamedQuery(name="ContentServiceRequest.findByResource", query="SELECT csr FROM ContentServiceRequest AS csr WHERE csr.resource.id = :resourceId"), @NamedQuery(name="ContentServiceRequest.findById", query="SELECT csr   FROM ContentServiceRequest AS csr WHERE csr.id = :id"), @NamedQuery(name="ContentServiceRequest.deleteByResources", query="DELETE FROM ContentServiceRequest csr WHERE csr.resource IN (:resources))")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONTENT_REQ_ID_SEQ")
@Table(name="RHQ_CONTENT_REQ")
public class ContentServiceRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_WITH_STATUS = "ContentServiceRequest.findWithStatus";
    public static final String QUERY_FIND_BY_RESOURCE_WITH_STATUS = "ContentServiceRequest.findByResourceWithStatus";
    public static final String QUERY_FIND_BY_RESOURCE_WITH_NOT_STATUS = "ContentServiceRequest.findByResourceWithNotStatus";
    public static final String QUERY_FIND_BY_RESOURCE = "ContentServiceRequest.findByResource";
    public static final String QUERY_FIND_BY_ID = "ContentServiceRequest.findById";
    public static final String QUERY_DELETE_BY_RESOURCES = "ContentServiceRequest.deleteByResources";
    @Column(name="ID", nullable=false)
    @GeneratedValue(generator="SEQ", strategy=GenerationType.SEQUENCE)
    @Id
    private int id;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Resource resource;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ContentRequestStatus status = ContentRequestStatus.IN_PROGRESS;
    @Column(name="ERROR_MESSAGE", nullable=true)
    private String errorMessage;
    @Column(name="NOTES", nullable=true)
    private String notes;
    @Column(name="SUBJECT_NAME", nullable=false)
    private String subjectName;
    @Column(name="CTIME", nullable=false)
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    private long mtime = System.currentTimeMillis();
    @Column(name="REQUEST_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ContentRequestType contentRequestType;
    @OneToMany(mappedBy="contentServiceRequest", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private Set<InstalledPackageHistory> installedPackageHistory;

    public ContentServiceRequest() {
    }

    public ContentServiceRequest(Resource resource, String subjectName, ContentRequestType contentRequestType) {
        this.resource = resource;
        this.subjectName = subjectName;
        this.contentRequestType = contentRequestType;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ContentRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContentRequestStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public long getCtime() {
        return this.ctime;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public Date getCreatedDate() {
        return new Date(this.ctime);
    }

    public long getLastModifiedTime() {
        return this.mtime;
    }

    public Date getLastModifiedDate() {
        return new Date(this.mtime);
    }

    public ContentRequestType getContentRequestType() {
        return this.contentRequestType;
    }

    public void setContentRequestType(ContentRequestType contentRequestType) {
        this.contentRequestType = contentRequestType;
    }

    public Set<InstalledPackageHistory> getInstalledPackageHistory() {
        return this.installedPackageHistory;
    }

    public void addInstalledPackageHistory(InstalledPackageHistory installedPackage) {
        if (this.installedPackageHistory == null) {
            this.installedPackageHistory = new HashSet<InstalledPackageHistory>();
        }
        this.installedPackageHistory.add(installedPackage);
    }

    public void setInstalledPackageHistory(Set<InstalledPackageHistory> installedPackageHistory) {
        this.installedPackageHistory = installedPackageHistory;
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public long getDuration() {
        long start = this.ctime;
        long end = this.mtime;
        if (this.status == null || this.status == ContentRequestStatus.IN_PROGRESS) {
            end = System.currentTimeMillis();
        }
        return end - start;
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        result = 31 * result + (this.subjectName == null ? 0 : this.subjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ContentServiceRequest)) {
            return false;
        }
        ContentServiceRequest other = (ContentServiceRequest)obj;
        if (this.ctime != other.ctime) {
            return false;
        }
        return !(this.subjectName == null ? other.subjectName != null : !this.subjectName.equals(other.subjectName));
    }
}

