/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.discovery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.util.exception.ExceptionPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long requestId;
    private Agent agent;
    private Set<Resource> addedRoots = new LinkedHashSet<Resource>();
    private List<ExceptionPackage> errors = new ArrayList<ExceptionPackage>();
    private long startTime;
    private long endTime;
    private boolean runtimeReport;

    public InventoryReport(Agent agent) {
        this.agent = agent;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public Set<Resource> getAddedRoots() {
        return this.addedRoots;
    }

    public void addAddedRoot(Resource resource) {
        this.addedRoots.add(resource);
    }

    public synchronized List<ExceptionPackage> getErrors() {
        return this.errors;
    }

    public void addError(ExceptionPackage error) {
        this.errors.add(error);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isRuntimeReport() {
        return this.runtimeReport;
    }

    public void setRuntimeReport(boolean runtimeReport) {
        this.runtimeReport = runtimeReport;
    }

    public int getResourceCount() {
        int count = 0;
        for (Resource r : this.addedRoots) {
            count += this.countResourceHierarchy(r);
        }
        return count;
    }

    private int countResourceHierarchy(Resource r) {
        int count = 1;
        for (Resource child : r.getChildResources()) {
            count += this.countResourceHierarchy(child);
        }
        return count;
    }
}

