/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import org.rhq.core.domain.measurement.util.MeasurementConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MeasurementUnits {
    NONE("", Family.ABSOLUTE, Scale.ONE),
    PERCENTAGE("%", Family.RELATIVE, Scale.HECTO),
    BYTES("B", Family.BYTES, Scale.ONE),
    KILOBYTES("KB", Family.BYTES, Scale.KILO),
    MEGABYTES("MB", Family.BYTES, Scale.MEGA),
    GIGABYTES("GB", Family.BYTES, Scale.GIGA),
    TERABYTES("TB", Family.BYTES, Scale.TERA),
    PETABYTES("PB", Family.BYTES, Scale.PETA),
    BITS("b", Family.BITS, Scale.ONE),
    KILOBITS("Kb", Family.BITS, Scale.KILO),
    MEGABITS("Mb", Family.BITS, Scale.MEGA),
    GIGABITS("Gb", Family.BITS, Scale.GIGA),
    TERABITS("Tb", Family.BITS, Scale.TERA),
    PETABITS("Pb", Family.BITS, Scale.PETA),
    EPOCH_MILLISECONDS("", Family.DURATION, Scale.MILLI),
    EPOCH_SECONDS("", Family.DURATION, Scale.SEC),
    JIFFYS("j", Family.TIME, Scale.JIFFY),
    NANOSECONDS("ns", Family.TIME, Scale.NANO),
    MICROSECONDS("us", Family.TIME, Scale.MICRO),
    MILLISECONDS("ms", Family.TIME, Scale.MILLI),
    SECONDS("s", Family.TIME, Scale.SEC),
    MINUTES("m", Family.TIME, Scale.MIN),
    HOURS("h", Family.TIME, Scale.HOUR),
    DAYS("d", Family.TIME, Scale.DAY),
    CELSIUS("C", Family.TEMPERATURE, Scale.ONE),
    KELVIN("K", Family.TEMPERATURE, Scale.ONE),
    FAHRENHEIGHT("F", Family.TEMPERATURE, Scale.ONE);

    private String displayUnits;
    private Family family;
    private Scale scale;

    private MeasurementUnits(String displayUnits, Family family, Scale scale) {
        if (displayUnits.length() > 5) {
            throw new RuntimeException("Screen real estate is expensive; displayUnits must be 5 characters or less");
        }
        this.displayUnits = displayUnits;
        this.family = family;
        this.scale = scale;
    }

    public static MeasurementUnits getUsingDisplayUnits(String displayUnits, Family family) {
        for (MeasurementUnits units : MeasurementUnits.values()) {
            if (units.getFamily() != family || !units.toString().equalsIgnoreCase(displayUnits)) continue;
            return units;
        }
        return null;
    }

    public MeasurementUnits getBaseUnits() {
        if (this.family == Family.BYTES) {
            return BYTES;
        }
        if (this.family == Family.BITS) {
            return BITS;
        }
        if (this.family == Family.TIME) {
            return SECONDS;
        }
        if (this.family == Family.TEMPERATURE) {
            return CELSIUS;
        }
        if (this.family == Family.ABSOLUTE || this.family == Family.DURATION || this.family == Family.RELATIVE) {
            return this;
        }
        return null;
    }

    public boolean isComparableTo(MeasurementUnits other) {
        return this.family == other.family;
    }

    public static Double scaleUp(Double value, MeasurementUnits units) {
        if (null == units || Family.RELATIVE != units.family) {
            return value;
        }
        return Scale.scaleUp(value, units.scale);
    }

    public static Double scaleDown(Double value, MeasurementUnits units) {
        if (null == units || Family.RELATIVE != units.family) {
            return value;
        }
        return Scale.scaleDown(value, units.scale);
    }

    public static Double calculateOffset(MeasurementUnits first, MeasurementUnits second) throws MeasurementConversionException {
        if (!first.isComparableTo(second)) {
            throw new MeasurementConversionException("Can not convert " + first.name() + " to " + second.name());
        }
        return Scale.calculateOffset(first.scale, second.scale);
    }

    public Family getFamily() {
        return this.family;
    }

    public Scale getScale() {
        return this.scale;
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.displayUnits;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scale {
        CENTI(Type.SIZE),
        ONE(Type.SIZE, CENTI, 100.0),
        HECTO(Type.SIZE, ONE, 100.0),
        KILO(Type.SIZE, ONE, 1024.0),
        MEGA(Type.SIZE, KILO, 1024.0),
        GIGA(Type.SIZE, MEGA, 1024.0),
        TERA(Type.SIZE, GIGA, 1024.0),
        PETA(Type.SIZE, TERA, 1024.0),
        JIFFY(Type.TIME),
        NANO(Type.TIME, JIFFY, 1000.0),
        MICRO(Type.TIME, NANO, 1000.0),
        MILLI(Type.TIME, MICRO, 1000.0),
        SEC(Type.TIME, MILLI, 1000.0),
        MIN(Type.TIME, SEC, 60.0),
        HOUR(Type.TIME, MIN, 60.0),
        DAY(Type.TIME, HOUR, 24.0),
        WEEK(Type.TIME, DAY, 7.0),
        YEAR(Type.TIME, WEEK, 52.0);

        private Type type;
        private Scale comparisonScale;
        private double offset;

        private Scale(Type type) {
            this.type = type;
        }

        private Scale(Type type, Scale comparisonScale, double offset) {
            this(type);
            this.comparisonScale = comparisonScale;
            this.offset = offset;
        }

        static Double scaleUp(Double value, Scale scale) {
            if (null == scale) {
                return 0.0;
            }
            return value * scale.offset;
        }

        static Double scaleDown(Double value, Scale scale) {
            if (null == scale) {
                return 0.0;
            }
            return value / scale.offset;
        }

        static Double calculateOffset(Scale first, Scale second) {
            Scale lower;
            Scale higher;
            if (first.type != second.type) {
                return null;
            }
            if (first.comparisonScale == null && second.comparisonScale == null) {
                return 1.0;
            }
            if (first.comparisonScale == null) {
                higher = second;
                lower = first;
            } else if (second.comparisonScale == null) {
                higher = first;
                lower = second;
            } else if (first.comparisonScale.ordinal() > second.comparisonScale.ordinal()) {
                higher = first;
                lower = second;
            } else if (first.comparisonScale.ordinal() < second.comparisonScale.ordinal()) {
                higher = second;
                lower = first;
            } else {
                return 1.0;
            }
            double results = 1.0;
            Scale movingScale = higher;
            while (movingScale != lower && movingScale.comparisonScale != null) {
                results *= movingScale.offset;
                movingScale = movingScale.comparisonScale;
            }
            if (first == lower) {
                return 1.0 / results;
            }
            return results;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            NONE,
            SIZE,
            TIME;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Family {
        ABSOLUTE,
        BITS,
        BYTES,
        DURATION,
        RELATIVE,
        TIME,
        TEMPERATURE;

    }
}

