/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.util.SortItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sorter<T> {
    private List<SortItem<T>> list = null;

    public List<SortItem<T>> sort(List<SortItem<T>> lst) {
        this.list = lst;
        ArrayList<SortItem<T>> res = new ArrayList<SortItem<T>>();
        SortItem<T> inmost = null;
        do {
            if ((inmost = this.getInmost()) == null) continue;
            res.add(inmost);
            this.remove(inmost);
        } while (!this.list.isEmpty() && inmost != null);
        if (!this.list.isEmpty()) {
            throw new IllegalArgumentException("Can not sort list:" + this.list);
        }
        return res;
    }

    private void remove(SortItem<T> item) {
        this.list.remove(item);
        for (SortItem<T> o : this.list) {
            o.getWithin().remove(item);
        }
    }

    private SortItem<T> getInmost() {
        SortItem<T> res = null;
        for (SortItem<T> o : this.list) {
            if (!o.getWithin().isEmpty() || !this.nobodyWantsAround(o)) continue;
            res = o;
            break;
        }
        return res;
    }

    private boolean nobodyWantsAround(SortItem<T> item) {
        boolean res = true;
        for (SortItem<T> o : this.list) {
            if (!o.getAround().contains(item)) continue;
            res = false;
            break;
        }
        return res;
    }
}

